% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maxcombofunctions-exampledocumentation.R,
%   R/maxcombofunctions.R
\name{oogetdoublemaxcombocutoff}
\alias{oogetdoublemaxcombocutoff}
\title{Compute the cutoff value for the max-combo test statistic at a single timepoint}
\usage{
oogetdoublemaxcombocutoff(
  oodataframe,
  oolistfunctionweightasafunctionofstminus = base::list(function(oodoublestminus) {    
    base::return(1) }),
  oostringorsymbolid = "id",
  oostringorsymboltreated = "treated",
  oostringorsymbolAtime = "Atime",
  oostringorsymbolBtime = "Btime",
  oostringorsymbolBobserved = "Bobserved",
  oostringorsymbolCtime = "Ctime",
  oostringorsymbolCobserved = "Cobserved",
  oodoublealpha = 0.025,
  oointnmaxiter = 25L,
  oodoublelower = -10,
  oodoubleupper = 10,
  oodoublefscaletolerance = 1e-05
)
}
\arguments{
\item{oodataframe}{A data frame containing time-to-event data from two different arms.}

\item{oolistfunctionweightasafunctionofstminus}{A list of one or more weighting functions.  Each weighting function should take as input the pooled Kaplan-Meier estimate of survival across the two arms (i.e., a double between 0 and 1, inclusive) and output a single weight (i.e., a double, typically greater than or equal to zero).  Defaults to the following list of a single weighting function that is identically 1, which results in the usual standardized log-rank test statistic: \code{base::list(function(oodoublestminus){ base::return(1) } )}}

\item{oostringorsymbolid}{The name of the column in the supplied data frame for the id variable.  Defaults to "id".  The id variable should take a unique value for each subject.  The column with this name in the data frame can be an integer vector with a different integer for each subject; the function will most likely also work if the column is a character vector with a different value for each subject.}

\item{oostringorsymboltreated}{The name of the column in the supplied data frame for a treatment indicator variable.  Defaults to "treated".  The treatment indicator variable is a variable indicating which of the two arms the subject is in.  The column with this name in the data frame should be an integer vector that takes only the value 0L (e.g., for placebo) or the value 1L (e.g., for a new drug or therapy).  The test statistic that is returned by this function will generally be for a test that the arm represented by subjects with treatment indicator 1L is superior to the arm represented by subjects with treatment indicator 0L (i.e., a one-sided test of superiority of arm 1 over arm 0).}

\item{oostringorsymbolAtime}{The name of the column in the supplied data frame for the Atime variable.  Defaults to "Atime".  Atime is the absolute time the subject enters the study.  The column with this name in the data frame can be vector of doubles; the function will most likely also work if the column is a vector of integers.}

\item{oostringorsymbolBtime}{The name of the column in the supplied data frame for the Btime variable.  Defaults to "Btime".  Btime is the absolute time of an event or censoring, whichever comes first.  The column with this name in the data frame can be vector of doubles; the function will most likely also work if the column is a vector of integers.}

\item{oostringorsymbolBobserved}{The name of the column in the supplied data frame for the Bobserved variable.  Defaults to "Bobserved".  Bobserved should be TRUE if the event was observed.  The column with this name in the data frame can be a logical vector; the function will most likely also work if the column is a vector of integers (i.e., with 1L in place of TRUE and 0L in place of FALSE).}

\item{oostringorsymbolCtime}{The name of the column in the supplied data frame for the Ctime variable.  Defaults to "Ctime".  Ctime is the absolute time of an event or censoring, whichever comes first.  The column with this name in the data frame can be vector of doubles; the function will most likely also work if the column is a vector of integers.}

\item{oostringorsymbolCobserved}{The name of the column in the supplied data frame for the Cobserved variable.  Defaults to "Cobserved".  Cobserved should be TRUE if censoring occurred (and so the event was not observed).  The column with this name in the data frame can be a logical vector; the function will most likely also work if the column is a vector of integers (i.e., with 1L in place of TRUE and 0L in place of FALSE).}

\item{oodoublealpha}{A double that is the user-specified nominal type I error rate.  Defaults to 0.025.  This value should be strictly between 0 and 1.}

\item{oointnmaxiter}{An integer that is maximum number of iterations used by the bisection method while finding the cutoff.  Defaults to 25L.  This value can be increased to 50L, 100L, or 200L if greater accuracy is desired while finding the cutoff; anything greater than that would typically not be needed.}

\item{oodoublelower}{A double that is the lower bound of the interval within which the cutoff is searched for.  Defaults to -10.}

\item{oodoubleupper}{A double that is the upper bound of the interval within which the cutoff is searched for.  Defaults to 10.}

\item{oodoublefscaletolerance}{A double that is related to early stopping of the bisection method; if the bisection method finds a cutoff value for which the absolute value of the difference between the nominal type I error rate when using that cutoff value and the user-specified nominal type I error rate is less than or equal to \code{oodoublefscaletolerance}, the bisection method will stop and return that cutoff value.  Defaults to 0.00001.  This value can be decreased to a smaller strictly positive value if greater accuracy is desired while finding the cutoff.}
}
\value{
A double
}
\description{
This function computes the cutoff value for a user-specified nominal type I error rate (also known as a user-specified "alpha") for the max-combo test statistic for comparing times to an event from two different arms at a single timepoint; please note that this is \emph{not} a cutoff for a group sequential test procedure involving two or more timepoints, but rather a cutoff for a scenario in which there is only one planned analysis timepoint.  If the true survival curves from the two arms are not at all different, then the probability, before performing the experiment, that the max-combo statistic will be greater than the cutoff value returned by this function, is less than or approximately equal to (but typically approximately equal to) the user-specified nominal type I error rate (e.g., 0.025 for a confirmatory clinical trial). The max-combo test statistic is the maximum of multiple standardized weighted log-rank test statistics.  The user of the function is expected to provide the function with a data frame containing the time-to-event data for the two arms; additionally, this data frame is expected to be in a particular format (see more details below).  Additionally, the user of the function is expected to provide a list of one or more weighting functions to use for the respective one or more weighted log-rank tests; in particular this function only allows the user to specify a weighting function that takes as input the Kaplan-Meier estimate for the survival curve obtained by pooling both of the two arms (a double that is between 0 and 1, inclusive) and provides as output a weight (a double that is typically greater than or equal to zero); note that the Fleming-Harrington class of weighting functions falls within what can be specified in this way.  If no list of weighting functions is provided, a single weighting function that is identically 1 is used, which means that the cutoff that is returned is exactly equal to the cutoff for the usual standardized log-rank test statistic (e.g., approximately 1.96 for a user-specified nominal type I error rate of 0.025).

The supplied data frame is expected to have one row for each subject.  The data frame should have the following columns:
\itemize{
\item \code{id} - a variable that takes a unique value for each subject
\item \code{treated} - should be 0 for subjects in the control arm and 1 for subjects in the experimental arm.
\item \code{Atime} - the absolute time the subject enters the study
\item \code{Btime} - the absolute time of an event or censoring, whichever comes first
\item \code{Bobserved} - should be TRUE if the event was observed
\item \code{Ctime} - the absolute time of an event or censoring, whichever comes first
\item \code{Cobserved} - should be TRUE if censoring occurred (and so the event was not observed)
}

The columns in the data frame do not have to be named exactly as above; however, if different names are used, those names must be specified as arguments to the function.  Please see below for more detail regarding how to specify those names and for more detail regarding the expectations of the function regarding the columns in the data frame.
}
\examples{
\donttest{

# -------------------------------------------------------------------------------
# Example 1: Usage on a single deterministic dataset in which the drug halves
# the hazard at all times (i.e., a proportional hazards situation)
# -------------------------------------------------------------------------------

oointnparticipants=100L
oointnparticipantsplacebo=oointnparticipants/2L
oointnparticipantsactive=oointnparticipants/2L

oodoublerateplacebo=0.250
oodoublerateactive=0.125

oovecinttreated=c(
  base::rep(0L,length.out=oointnparticipantsplacebo),
  base::rep(1L,length.out=oointnparticipantsactive)
)
oovecdoubletAabsolute=c( #the start time, i.e., when the subject enters the study.
  base::seq(from=0.0,to=2.0,length.out=oointnparticipantsplacebo),
  base::seq(from=0.0,to=2.0,length.out=oointnparticipantsactive)
)
#the duration of time from when the subject enters the study until the subject experiences the event
oovecdoubletAtoB=c(
  stats::qexp(
    base::seq(from=0.0,to=0.98,length.out=oointnparticipantsplacebo),
    rate=oodoublerateplacebo
  ),
  stats::qexp(
    base::seq(from=0.0,to=0.98,length.out=oointnparticipantsactive),
    rate=oodoublerateactive
  )
)
oovecdoubletBabsolute=oovecdoubletAabsolute + oovecdoubletAtoB
#the analysis takes place at absolute time 6.0 months, and no other censoring (e.g., dropout) occurs
oovecdoubletCabsolute=6.0
oovecdoubletminBvsC=base::pmin(oovecdoubletBabsolute,oovecdoubletCabsolute)
oovecboolobservedB=(oovecdoubletBabsolute < oovecdoubletCabsolute)
oovecboolobservedC=(oovecdoubletCabsolute <= oovecdoubletBabsolute)

oodataframe=dplyr::tibble(id=1L:oointnparticipants,
                          treated=oovecinttreated,
                          Atime=oovecdoubletAabsolute,
                          Btime=oovecdoubletminBvsC,
                          Bobserved=oovecboolobservedB,
                          Ctime=oovecdoubletminBvsC,
                          Cobserved=oovecboolobservedC)
 
#standardized log-rank test statistic
oolistweightingfunctionsJustLogrank=base::list(
  logrank=function(stminus){ base::return(1.0) }
)
maxcombo::oogetdoublemaxcomboteststatistic(
  oodataframe = oodataframe,
  oolistfunctionweightasafunctionofstminus = oolistweightingfunctionsJustLogrank
) #test statistic 2.92
maxcombo::oogetdoublemaxcombotestpvalue(
  oodataframe = oodataframe,
  oolistfunctionweightasafunctionofstminus = oolistweightingfunctionsJustLogrank
) #p-value 0.0017
maxcombo::oogetdoublemaxcombocutoff(
  oodataframe = oodataframe,
  oolistfunctionweightasafunctionofstminus = oolistweightingfunctionsJustLogrank,
  oodoublealpha = 0.025
) #cutoff of 1.96 for the max-combo test statistic
#the max-combo test statistic exceeds the cutoff (since 2.92 > 1.96), so you can declare that
#the survival curves in the two arms are statistically significantly different at the 0.025 level

#standardized weighted log-rank test statistic with Fleming-Harrington 0-1 weighting function,
#which places greater weight on later times
oolistweightingfunctionsJustFlemingHarrington01=base::list(
  flemingharrington01=function(stminus){ base::return(1.0 - stminus) }
)
maxcombo::oogetdoublemaxcomboteststatistic(
  oodataframe = oodataframe,
  oolistfunctionweightasafunctionofstminus = oolistweightingfunctionsJustFlemingHarrington01
) #test statistic 2.83
maxcombo::oogetdoublemaxcombotestpvalue(
  oodataframe = oodataframe,
  oolistfunctionweightasafunctionofstminus = oolistweightingfunctionsJustFlemingHarrington01
) #p-value 0.0023
maxcombo::oogetdoublemaxcombocutoff(
  oodataframe = oodataframe,
  oolistfunctionweightasafunctionofstminus = oolistweightingfunctionsJustFlemingHarrington01,
  oodoublealpha = 0.025
) #cutoff of 1.96 for the max-combo test statistic
#the max-combo test statistic exceeds the cutoff (since 2.83 > 1.96), so you can declare that
#the survival curves in the two arms are statistically significantly different at the 0.025 level

#standardized weighted log-rank test statistic with Fleming-Harrington 1-0 weighting function,
#which places greater weight on earlier times
oolistweightingfunctionsJustFlemingHarrington10=base::list(
  flemingharrington10=function(stminus){ base::return(stminus) }
)
maxcombo::oogetdoublemaxcomboteststatistic(
  oodataframe = oodataframe,
  oolistfunctionweightasafunctionofstminus = oolistweightingfunctionsJustFlemingHarrington10
) #test statistic 2.71
maxcombo::oogetdoublemaxcombotestpvalue(
  oodataframe = oodataframe,
  oolistfunctionweightasafunctionofstminus = oolistweightingfunctionsJustFlemingHarrington10
) #p-value 0.0033
maxcombo::oogetdoublemaxcombocutoff(
  oodataframe = oodataframe,
  oolistfunctionweightasafunctionofstminus = oolistweightingfunctionsJustFlemingHarrington10,
  oodoublealpha = 0.025
) #cutoff of 1.96 for the max-combo test statistic
#the max-combo test statistic exceeds the cutoff (since 2.71 > 1.96), so you can declare that
#the survival curves in the two arms are statistically significantly different at the 0.025 level
 
#the max-combo test statistic based on the first two of the above
oolistweightingfunctionsLogrankAndFlemingHarrington01=base::list(
  logrank=function(stminus){ base::return(1.0) },
  flemingharrington01=function(stminus){ base::return(1.0 - stminus) }
)
maxcombo::oogetdoublemaxcomboteststatistic(
  oodataframe = oodataframe,
  oolistfunctionweightasafunctionofstminus = oolistweightingfunctionsLogrankAndFlemingHarrington01
) #test statistic 2.92, i.e., just the maximum of 2.92 (from the log-rank test statistic) and 2.83
# (from the weighted log-rank test statistic with Fleming-Harrington 0-1 weighting function)
maxcombo::oogetdoublemaxcombotestpvalue(
  oodataframe = oodataframe,
  oolistfunctionweightasafunctionofstminus = oolistweightingfunctionsLogrankAndFlemingHarrington01
) #p-value 0.0028
maxcombo::oogetdoublemaxcombocutoff(
  oodataframe = oodataframe,
  oolistfunctionweightasafunctionofstminus = oolistweightingfunctionsLogrankAndFlemingHarrington01,
  oodoublealpha = 0.025
) #cutoff of 2.13 for the max-combo test statistic
#the max-combo test statistic exceeds the cutoff (since 2.92 > 2.13), so you can declare that
#the survival curves in the two arms are statistically significantly different at the 0.025 level

#the max-combo test statistic based on the first three of the above
oolistweightingfunctionsLogrankAndFlemingHarrington01AndFlemingHarrington10=base::list(
  logrank=function(stminus){ base::return(1.0) },
  flemingharrington01=function(stminus){ base::return(1.0 - stminus) },
  flemingharrington10=function(stminus){ base::return(stminus) }
)
maxcombo::oogetdoublemaxcomboteststatistic(
  oodataframe = oodataframe,
  oolistfunctionweightasafunctionofstminus = 
  oolistweightingfunctionsLogrankAndFlemingHarrington01AndFlemingHarrington10
) #test statistic 2.92, i.e., just the maximum of 2.92 (from the log-rank test statistic), 2.83
# (from the weighted log-rank test statistic with Fleming-Harrington 0-1 weighting function), and
# 2.71 (from the weighted log-rank test statistic with Fleming-Harrington 1-0 weighting function)
maxcombo::oogetdoublemaxcombotestpvalue(
  oodataframe = oodataframe,
  oolistfunctionweightasafunctionofstminus = 
  oolistweightingfunctionsLogrankAndFlemingHarrington01AndFlemingHarrington10
) #p-value 0.0032
maxcombo::oogetdoublemaxcombocutoff(
  oodataframe = oodataframe,
  oolistfunctionweightasafunctionofstminus = 
  oolistweightingfunctionsLogrankAndFlemingHarrington01AndFlemingHarrington10,
  oodoublealpha = 0.025,
  oointnmaxiter = 100L
) #cutoff of 2.19 for the max-combo test statistic
#the max-combo test statistic exceeds the cutoff (since 2.92 > 2.19), so you can declare that
#the survival curves in the two arms are statistically significantly different at the 0.025 level


# --------------------------------------------------------------------------------------------
# Example 2: Usage on a single deterministic dataset in which the drug delays
# the event by exactly one month for each subject (i.e., an early treatment effect situation)
# --------------------------------------------------------------------------------------------

oointnparticipants=100L
oointnparticipantsplacebo=oointnparticipants/2L
oointnparticipantsactive=oointnparticipants/2L

oodoublerateplacebo=0.250

oovecinttreated=c(
  base::rep(0L,length.out=oointnparticipantsplacebo),
  base::rep(1L,length.out=oointnparticipantsactive)
)
oovecdoubletAabsolute=c( #the start time, i.e., when the subject enters the study.
  base::seq(from=0.0,to=2.0,length.out=oointnparticipantsplacebo),
  base::seq(from=0.0,to=2.0,length.out=oointnparticipantsactive)
)
#the duration of time from when the subject enters the study until the subject experiences the event
oovecdoubletAtoB=c(
  stats::qexp(
    base::seq(from=0.0,to=0.98,length.out=oointnparticipantsplacebo),
    rate=oodoublerateplacebo
  ),
  stats::qexp(
    base::seq(from=0.0,to=0.98,length.out=oointnparticipantsactive),
    rate=oodoublerateplacebo
  ) + 1.0 #note the addition of 1.0 month time to event here for the active arm
)
oovecdoubletBabsolute=oovecdoubletAabsolute + oovecdoubletAtoB
#the analysis takes place at absolute time 6.0 months, and no other censoring (e.g., dropout) occurs
oovecdoubletCabsolute=6.0
oovecdoubletminBvsC=base::pmin(oovecdoubletBabsolute,oovecdoubletCabsolute)
oovecboolobservedB=(oovecdoubletBabsolute < oovecdoubletCabsolute)
oovecboolobservedC=(oovecdoubletCabsolute <= oovecdoubletBabsolute)

oodataframe=dplyr::tibble(id=1L:oointnparticipants,
                          treated=oovecinttreated,
                          Atime=oovecdoubletAabsolute,
                          Btime=oovecdoubletminBvsC,
                          Bobserved=oovecboolobservedB,
                          Ctime=oovecdoubletminBvsC,
                          Cobserved=oovecboolobservedC)

#standardized log-rank test statistic
oolistweightingfunctionsJustLogrank=base::list(
  logrank=function(stminus){ base::return(1.0) }
)
maxcombo::oogetdoublemaxcomboteststatistic(
  oodataframe = oodataframe,
  oolistfunctionweightasafunctionofstminus = oolistweightingfunctionsJustLogrank
) #test statistic 1.66
maxcombo::oogetdoublemaxcombotestpvalue(
  oodataframe = oodataframe,
  oolistfunctionweightasafunctionofstminus = oolistweightingfunctionsJustLogrank
) #p-value 0.05
maxcombo::oogetdoublemaxcombocutoff(
  oodataframe = oodataframe,
  oolistfunctionweightasafunctionofstminus = oolistweightingfunctionsJustLogrank,
  oodoublealpha = 0.025
) #cutoff of 1.96 for the max-combo test statistic
#the max-combo test statistic does not exceed the cutoff (since 1.66 < 1.96), so you fail to reject
#that the survival curves in the two arms are the same at the 0.025 level

#standardized weighted log-rank test statistic with Fleming-Harrington 0-1 weighting function,
#which places greater weight on later times
oolistweightingfunctionsJustFlemingHarrington01=base::list(
  flemingharrington01=function(stminus){ base::return(1.0 - stminus) }
)
maxcombo::oogetdoublemaxcomboteststatistic(
  oodataframe = oodataframe,
  oolistfunctionweightasafunctionofstminus = oolistweightingfunctionsJustFlemingHarrington01
) #test statistic 0.53
maxcombo::oogetdoublemaxcombotestpvalue(
  oodataframe = oodataframe,
  oolistfunctionweightasafunctionofstminus = oolistweightingfunctionsJustFlemingHarrington01
) #p-value 0.30
maxcombo::oogetdoublemaxcombocutoff(
  oodataframe = oodataframe,
  oolistfunctionweightasafunctionofstminus = oolistweightingfunctionsJustFlemingHarrington01,
  oodoublealpha = 0.025
) #cutoff of 1.96 for the max-combo test statistic
#the max-combo test statistic does not exceed the cutoff (since 0.53 < 1.96), so you fail to reject
#that the survival curves in the two arms are the same at the 0.025 level

#standardized weighted log-rank test statistic with Fleming-Harrington 1-0 weighting function,
#which places greater weight on earlier times
oolistweightingfunctionsJustFlemingHarrington10=base::list(
  flemingharrington10=function(stminus){ base::return(stminus) }
)
maxcombo::oogetdoublemaxcomboteststatistic(
  oodataframe = oodataframe,
  oolistfunctionweightasafunctionofstminus = oolistweightingfunctionsJustFlemingHarrington10
) #test statistic 2.07
maxcombo::oogetdoublemaxcombotestpvalue(
  oodataframe = oodataframe,
  oolistfunctionweightasafunctionofstminus = oolistweightingfunctionsJustFlemingHarrington10
) #p-value 0.02
maxcombo::oogetdoublemaxcombocutoff(
  oodataframe = oodataframe,
  oolistfunctionweightasafunctionofstminus = oolistweightingfunctionsJustFlemingHarrington10,
  oodoublealpha = 0.025
) #cutoff of 1.96 for the max-combo test statistic
#the max-combo test statistic exceeds the cutoff (since 2.07 > 1.96), so you can declare that
#the survival curves in the two arms are statistically significantly different at the 0.025 level

#the max-combo test statistic based on the first two of the above
oolistweightingfunctionsLogrankAndFlemingHarrington01=base::list(
  logrank=function(stminus){ base::return(1.0) },
  flemingharrington01=function(stminus){ base::return(1.0 - stminus) }
)
maxcombo::oogetdoublemaxcomboteststatistic(
  oodataframe = oodataframe,
  oolistfunctionweightasafunctionofstminus = oolistweightingfunctionsLogrankAndFlemingHarrington01
) #test statistic 1.66, i.e., just the maximum of 1.66 (from the log-rank test statistic) and 0.53
# (from the weighted log-rank test statistic with Fleming-Harrington 0-1 weighting function)
maxcombo::oogetdoublemaxcombotestpvalue(
  oodataframe = oodataframe,
  oolistfunctionweightasafunctionofstminus = oolistweightingfunctionsLogrankAndFlemingHarrington01
) #p-value 0.07
maxcombo::oogetdoublemaxcombocutoff(
  oodataframe = oodataframe,
  oolistfunctionweightasafunctionofstminus = oolistweightingfunctionsLogrankAndFlemingHarrington01,
  oodoublealpha = 0.025
) #cutoff of 2.13 for the max-combo test statistic
#the max-combo test statistic does not exceed the cutoff (since 1.66 < 2.13), so you fail to reject
#that the survival curves in the two arms are the same at the 0.025 level

#the max-combo test statistic based on the first three of the above
oolistweightingfunctionsLogrankAndFlemingHarrington01AndFlemingHarrington10=base::list(
  logrank=function(stminus){ base::return(1.0) },
  flemingharrington01=function(stminus){ base::return(1.0 - stminus) },
  flemingharrington10=function(stminus){ base::return(stminus) }
)
maxcombo::oogetdoublemaxcomboteststatistic(
  oodataframe = oodataframe,
  oolistfunctionweightasafunctionofstminus =
  oolistweightingfunctionsLogrankAndFlemingHarrington01AndFlemingHarrington10
) #test statistic 2.07, i.e., just the maximum of 1.66 (from the log-rank test statistic), 0.53
# (from the weighted log-rank test statistic with Fleming-Harrington 0-1 weighting function), and
# 2.07 (from the weighted log-rank test statistic with Fleming-Harrington 1-0 weighting function)
maxcombo::oogetdoublemaxcombotestpvalue(
  oodataframe = oodataframe,
  oolistfunctionweightasafunctionofstminus = 
  oolistweightingfunctionsLogrankAndFlemingHarrington01AndFlemingHarrington10
) #p-value 0.03
maxcombo::oogetdoublemaxcombocutoff(
  oodataframe = oodataframe,
  oolistfunctionweightasafunctionofstminus = 
  oolistweightingfunctionsLogrankAndFlemingHarrington01AndFlemingHarrington10,
  oodoublealpha = 0.025,
  oointnmaxiter = 100L
) #cutoff of 2.20 for the max-combo test statistic
#the max-combo test statistic does not exceed the cutoff (since 2.06 < 2.20), so you fail to reject
#that the survival curves in the two arms are the same at the 0.025 level


# -------------------------------------------------------------------------------------------------
# Example 3: Usage on a single deterministic dataset in which subjects in the placebo arm all have
# the event after being on the study for 1.2 months (i.e., a delayed treatment effect situation)
# -------------------------------------------------------------------------------------------------
 
oointnparticipants=100L
oointnparticipantsplacebo=oointnparticipants/2L
oointnparticipantsactive=oointnparticipants/2L

oodoublerateactive=0.250

oovecinttreated=c(
  base::rep(0L,length.out=oointnparticipantsplacebo),
  base::rep(1L,length.out=oointnparticipantsactive)
)
oovecdoubletAabsolute=c( #the start time, i.e., when the subject enters the study.
  base::seq(from=0.0,to=2.0,length.out=oointnparticipantsplacebo),
  base::seq(from=0.0,to=2.0,length.out=oointnparticipantsactive)
)
#the duration of time from when the subject enters the study until the subject experiences the event
oovecdoubletAtoB=c(
  base::ifelse(
    stats::qexp(
      base::seq(from=0.0,to=0.98,length.out=oointnparticipantsplacebo),
      rate=oodoublerateactive
    ) <= 1.2,
    stats::qexp(
      base::seq(from=0.0,to=0.98,length.out=oointnparticipantsplacebo),
      rate=oodoublerateactive
    ),
    1.2
  ),
  stats::qexp(
    base::seq(from=0.0,to=0.98,length.out=oointnparticipantsactive),
    rate=oodoublerateactive
  )
)
oovecdoubletBabsolute=oovecdoubletAabsolute + oovecdoubletAtoB
#the analysis takes place at absolute time 6.0 months, and no other censoring (e.g., dropout) occurs
oovecdoubletCabsolute=6.0
oovecdoubletminBvsC=base::pmin(oovecdoubletBabsolute,oovecdoubletCabsolute)
oovecboolobservedB=(oovecdoubletBabsolute < oovecdoubletCabsolute)
oovecboolobservedC=(oovecdoubletCabsolute <= oovecdoubletBabsolute)

oodataframe=dplyr::tibble(id=1L:oointnparticipants,
                          treated=oovecinttreated,
                          Atime=oovecdoubletAabsolute,
                          Btime=oovecdoubletminBvsC,
                          Bobserved=oovecboolobservedB,
                          Ctime=oovecdoubletminBvsC,
                          Cobserved=oovecboolobservedC)

#standardized log-rank test statistic
oolistweightingfunctionsJustLogrank=base::list(
  logrank=function(stminus){ base::return(1.0) }
)
maxcombo::oogetdoublemaxcomboteststatistic(
  oodataframe = oodataframe,
  oolistfunctionweightasafunctionofstminus = oolistweightingfunctionsJustLogrank
) #test statistic 1.55
maxcombo::oogetdoublemaxcombotestpvalue(
  oodataframe = oodataframe,
  oolistfunctionweightasafunctionofstminus = oolistweightingfunctionsJustLogrank
) #p-value 0.06
maxcombo::oogetdoublemaxcombocutoff(
  oodataframe = oodataframe,
  oolistfunctionweightasafunctionofstminus = oolistweightingfunctionsJustLogrank,
  oodoublealpha = 0.025
) #cutoff of 1.96 for the max-combo test statistic
#the max-combo test statistic does not exceed the cutoff (since 1.55 < 1.96), so you fail to reject
#that the survival curves in the two arms are the same at the 0.025 level

#standardized weighted log-rank test statistic with Fleming-Harrington 0-1 weighting function,
#which places greater weight on later times
oolistweightingfunctionsJustFlemingHarrington01=base::list(
  flemingharrington01=function(stminus){ base::return(1.0 - stminus) }
)
maxcombo::oogetdoublemaxcomboteststatistic(
  oodataframe = oodataframe,
  oolistfunctionweightasafunctionofstminus = oolistweightingfunctionsJustFlemingHarrington01
) #test statistic 2.28
maxcombo::oogetdoublemaxcombotestpvalue(
  oodataframe = oodataframe,
  oolistfunctionweightasafunctionofstminus = oolistweightingfunctionsJustFlemingHarrington01
) #p-value 0.01
maxcombo::oogetdoublemaxcombocutoff(
  oodataframe = oodataframe,
  oolistfunctionweightasafunctionofstminus = oolistweightingfunctionsJustFlemingHarrington01,
  oodoublealpha = 0.025
) #cutoff of 1.96 for the max-combo test statistic
#the max-combo test statistic exceeds the cutoff (since 2.28 > 1.96), so you can declare that
#the survival curves in the two arms are statistically significantly different at the 0.025 level

#standardized weighted log-rank test statistic with Fleming-Harrington 1-0 weighting function,
#which places greater weight on earlier times
oolistweightingfunctionsJustFlemingHarrington10=base::list(
  flemingharrington10=function(stminus){ base::return(stminus) }
)
maxcombo::oogetdoublemaxcomboteststatistic(
  oodataframe = oodataframe,
  oolistfunctionweightasafunctionofstminus = oolistweightingfunctionsJustFlemingHarrington10
) #test statistic 1.35
maxcombo::oogetdoublemaxcombotestpvalue(
  oodataframe = oodataframe,
  oolistfunctionweightasafunctionofstminus = oolistweightingfunctionsJustFlemingHarrington10
) #p-value 0.09
maxcombo::oogetdoublemaxcombocutoff(
  oodataframe = oodataframe,
  oolistfunctionweightasafunctionofstminus = oolistweightingfunctionsJustFlemingHarrington10,
  oodoublealpha = 0.025
) #cutoff of 1.96 for the max-combo test statistic
#the max-combo test statistic does not exceed the cutoff (since 1.35 < 1.96), so you fail to reject
#that the survival curves in the two arms are the same at the 0.025 level

#the max-combo test statistic based on the first two of the above
oolistweightingfunctionsLogrankAndFlemingHarrington01=base::list(
  logrank=function(stminus){ base::return(1.0) },
  flemingharrington01=function(stminus){ base::return(1.0 - stminus) }
)
maxcombo::oogetdoublemaxcomboteststatistic(
  oodataframe = oodataframe,
  oolistfunctionweightasafunctionofstminus = oolistweightingfunctionsLogrankAndFlemingHarrington01
) #test statistic 2.28, i.e., just the maximum of 1.55 (from the log-rank test statistic) and 2.28
# (from the weighted log-rank test statistic with Fleming-Harrington 0-1 weighting function)
maxcombo::oogetdoublemaxcombotestpvalue(
  oodataframe = oodataframe,
  oolistfunctionweightasafunctionofstminus = oolistweightingfunctionsLogrankAndFlemingHarrington01
) #p-value 0.02
maxcombo::oogetdoublemaxcombocutoff(
  oodataframe = oodataframe,
  oolistfunctionweightasafunctionofstminus = oolistweightingfunctionsLogrankAndFlemingHarrington01,
  oodoublealpha = 0.025
) #cutoff of 2.13 for the max-combo test statistic
#the max-combo test statistic exceeds the cutoff (since 2.28 > 2.13), so you can declare that
#the survival curves in the two arms are statistically significantly different at the 0.025 level

#the max-combo test statistic based on the first three of the above
oolistweightingfunctionsLogrankAndFlemingHarrington01AndFlemingHarrington10=base::list(
  logrank=function(stminus){ base::return(1.0) },
  flemingharrington01=function(stminus){ base::return(1.0 - stminus) },
  flemingharrington10=function(stminus){ base::return(stminus) }
)
maxcombo::oogetdoublemaxcomboteststatistic(
  oodataframe = oodataframe,
  oolistfunctionweightasafunctionofstminus =
  oolistweightingfunctionsLogrankAndFlemingHarrington01AndFlemingHarrington10
) #test statistic 2.28, i.e., just the maximum of 1.55 (from the log-rank test statistic), 2.28
# (from the weighted log-rank test statistic with Fleming-Harrington 0-1 weighting function), and
# 1.35 (from the weighted log-rank test statistic with Fleming-Harrington 1-0 weighting function)
maxcombo::oogetdoublemaxcombotestpvalue(
  oodataframe = oodataframe,
  oolistfunctionweightasafunctionofstminus = 
  oolistweightingfunctionsLogrankAndFlemingHarrington01AndFlemingHarrington10
) #p-value 0.02
maxcombo::oogetdoublemaxcombocutoff(
  oodataframe = oodataframe,
  oolistfunctionweightasafunctionofstminus = 
  oolistweightingfunctionsLogrankAndFlemingHarrington01AndFlemingHarrington10,
  oodoublealpha = 0.025,
  oointnmaxiter = 200L
) #cutoff of 2.15 for the max-combo test statistic
#the max-combo test statistic exceeds the cutoff (since 2.28 > 2.15), so you can declare that
#the survival curves in the two arms are statistically significantly different at the 0.025 level
}
}
