% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/excel.R
\name{check_worksheet_name_violations}
\alias{check_worksheet_name_violations}
\title{Develop a warning message for malformed Excel worksheet names}
\usage{
check_worksheet_name_violations(candidate_worksheet_names)
}
\arguments{
\item{candidate_worksheet_names}{Worksheet names to be checked.}
}
\value{
\code{NULL} invisibly and a warning if any problems are detected.
}
\description{
\code{write_mat_to_excel()} can include worksheet names, but
it is important that they are legal names.
This function emits a warning when \code{candidate_worksheet_names}
is malformed.
}
\examples{
# No warning
check_worksheet_name_violations(c("abc", "123"))
\dontrun{
  # Warnings
  # Illegal characters
  check_worksheet_name_violations(c("abc", "["))
  # Empty name
  check_worksheet_name_violations(c("", "abc"))
  # Too long
  check_worksheet_name_violations(strrep("x", 32))
  # Duplicates
  check_worksheet_name_violations(c("abc123", "abc123"))
}
}
