% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/componentplot.R
\name{componentplot}
\alias{componentplot}
\title{Draws a Plot Showing the Number of Components as a Function of the Cutoff Value.}
\arguments{
\item{mx}{a square sequence similarity matrix}

\item{lower_bound}{lower bounds for calculating the inflection point in, default = 0}

\item{upper_bound}{upper bounds for calculating the inflection point in, default = 1}
}
\value{
A plot showing the number of components as a function of the cutoff threshold.
}
\description{
The function takes a square sequence similarity matrix and calculates
the number of independent components in which the sequence similarity between the
members is greater than a specified value (between 0 and 1). It creates a plots showing
the number of components corresponding to a given cutoff value. The function also
depicts the inflection point with a vertical line. Upper and lower bounds can be
provided between which the inflection point will be found (if it exists).

Version 0.0.1.
Author: Dr. Matthew Cserhati
Email: csmatyi@protonmail.com
March 19, 2023
}
\examples{
componentplot(xenarthra,0.75,0.9)
componentplot(xenarthra)

}
\references{
Mullner. <ArXiv:1109.2378>

Cserhati, Carter. (2020, Journal of Creation 34(3):41-50), <https://dl0.creation.com/articles/p137/c13759/j34-3_64-73.pdf>
}
