% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Forecast.R
\docType{class}
\name{Forecast-class}
\alias{Forecast-class}
\title{Class \code{Forecast}}
\description{
This S4 class represents the result of forecast using function \code{predictValue}.
}
\section{Slots}{

\describe{
\item{\code{data}}{(data.frame) Data frame including the predicted data and optionally the training data.}

\item{\code{models}}{(list) List of fitted ARIMA models.}

\item{\code{value}}{(character) Name of the value column.}

\item{\code{item}}{(character) Name of the item column.}

\item{\code{items}}{(character) IDs or Names of the items.}
}}

\section{Objects from the Class}{
 Objects can be created by calling the function
\code{predictValue}. This S4 class represents the result of a forecast.
}

\examples{
data("Amount")
prediction = predictValue(data = Amount,
    value = "amount",
    item = "item",
    timestamp = "date",
    temporalAggregation = "week",
    timeUnitsAhead = 3)
prediction
}
\author{
Leon Binder \email{leon.binder@th-deg.de}

Bernhard Bauer \email{bernhard.bauer@th-deg.de}

Michael Scholz \email{michael.scholz@th-deg.de}
}
\keyword{classes}
