#' Calibration data of a weights kit in the interval 1 mg to 1 kg
#'
#' An object of class \code{"massStandardKit"}, with calibration information
#' of mass standards with nominal masses in the interval 1 mg to 1 kg,
#' performed by the Mass Laboratory at the Instituto Nacional de Metrologia de
#' Colombia (2020-08-12).
#'
#' @format A list with 25 objects of class \code{massStandard()}
#' @source
#'   Mass Laboratory - Instituto Nacional de Metrologia de Colombia.
#'   CALIBRATION CERTIFICATE No. 4687.
"Box.E2.MS.Kit"

#' Calibration data of a E2 class mass standard of nominal mass 20 g.
#'
#' An object of class \code{"massStandard"}, with calibration information
#' of a mass standards with nominal mass of 20 g,
#' performed by the Mass Laboratory at the Instituto Nacional de Metrologia de
#' Colombia (2020-08-12).
#'
#' @format A list with 25 objects of class \code{massStandard()}
#' @source
#'   Mass Laboratory - Instituto Nacional de Metrologia de Colombia.
#'   CALIBRATION CERTIFICATE No. 4687.
"E2.MS.20g"
