% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/G_i.R
\name{G_i}
\alias{G_i}
\title{Global irradiance on Mars inclined surface}
\usage{
G_i(
  Ls,
  phi,
  longitude,
  Ts,
  z = Z(Ls = Ls, phi = phi, Ts = Ts),
  tau,
  al = albedo(latitude = phi, longitude = longitude, tau = tau),
  beta,
  gamma_c
)
}
\arguments{
\item{Ls}{Areocentric longitude [deg]}

\item{phi}{Planetary latitude [deg]}

\item{longitude}{Planetary longitude [deg]}

\item{Ts}{Solar time [h]}

\item{z}{Sun zenith angle [deg]. If not provided, calculated from Ls, phi, and Ts}

\item{tau}{Atmospheric optical depth (dimensionless)}

\item{al}{Surface albedo (dimensionless, 0-1). If not provided, calculated from latitude, longitude, and tau}

\item{beta}{Surface tilt/slope angle from horizontal [deg]}

\item{gamma_c}{Surface azimuth angle [deg]. Zero facing equator, east negative, west positive (-180 to +180)}
}
\value{
Global irradiance on inclined surface [W/m²]
}
\description{
Calculates the total solar irradiance (direct beam + diffuse + albedo-reflected) incident
on an inclined surface on Mars. Implements Equation 3 from Appelbaum, Flood & Norambuena (1994).
}
