% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcorr.lpp.R
\name{mcorr.lpp}
\alias{mcorr.lpp}
\title{Mark correlation functions for homogeneous point patterns on linear networks.}
\usage{
\method{mcorr}{lpp}(X,
ftype = c("variogram", "stoyan", "rcorr", "shimatani", "beisbart",
 "isham", "stoyancov", "schlather"),
r = NULL,
method = c("density","loess"),
normalise = TRUE,
f = NULL,
tol = 0.01,
...)
}
\arguments{
\item{X}{An object of class lpp.}

\item{ftype}{Type of the test function \eqn{t_f}. Currently any selection of \code{"variogram", "stoyan", "rcorr", "shimatani", "beisbart", "isham", "stoyancov", "schlather"}.}

\item{r}{Optional. The values of the argument \eqn{r} at which the mark correlation function should be evaluated.}

\item{method}{Type of smoothing, either \code{density} or \code{loess}. See details.}

\item{normalise}{If \code{normalise=FALSE}, only the numerator of the expression for the mark correlation function will be computed.}

\item{f}{Optional. Test function \eqn{t_f} used in the definition of the mark correlation function. If \code{ftype} is given, \eqn{t_f} should be \code{NULL}.}

\item{tol}{Tolerance used in the calculation of the conditional mean of the marks. This is used only if \code{ftype} is \code{schlather}.}

\item{...}{Arguments passed to \code{\link[spatstat.univar]{unnormdensity}} or \code{\link[stats]{loess}}.}
}
\value{
a data.frame which gives the estimated mark correlation function and the distance vector \eqn{r} at which the mark correlation function is estimated. If the point patten \eqn{X} has multiple real-valued marks, the estimated mark correlation function will be given for each mark. Name of columns will be the name of marks.
}
\description{
Mark correlation functions for homogeneous point patterns on linear networks.
}
\details{
For a homogeneous point process \eqn{X} on a linear network, the \eqn{t_f}-correlation function \eqn{\kappa_{t_f}(r)} is given as
\deqn{
\kappa_{t_f}(r)
    =
    \frac{
    \mathbb{E} \left[
    t_f \left(
    m_x, m_y
    \right) \mid x, y \in X
    \right]
    }{
    c_{t_f}
    },
    \quad
    d(x,y)=r,
}
where \eqn{m_x, m_y} are the marks of \eqn{x, y \in X}, \eqn{c_{t_f}} is a normalizing factor, and \eqn{d(x,y)=r} is the shortest-path distance. Therefore, each mark correlation function is defined by a specific test function \eqn{t_f(m_x, m_y)} and its associated normalising factor \eqn{c_{t_f}}. Let \eqn{\mu_m} and \eqn{\sigma^2_m} be the mean and variance of marks, then, the list below gives different test functions \eqn{t_f} and their normalised factors \eqn{c_{t_f}}, following distinct available \code{ftype}.

\describe{
  \item{variogram:}{
    \eqn{t_f(m_x, m_y) = \frac{1}{2}(m_x - m_y)^2},
    \eqn{c_{t_f} = \sigma^2_m}.
  }
  \item{stoyan:}{
    \eqn{t_f(m_x, m_y) = m_x m_y},
    \eqn{c_{t_f} = \mu^2_m}.
  }
  \item{rcorr:}{
    \eqn{t_f(m_x, m_y) = m_x},
    \eqn{c_{t_f} = \mu_m}.
  }
  \item{shimatani:}{
    \eqn{t_f(m_x, m_y) = (m_x - \mu_m)(m_y - \mu_m)},
    \eqn{c_{t_f} = \sigma^2_m}.
  }
  \item{beisbart:}{
    \eqn{t_f(m_x, m_y) = m_x + m_y},
    \eqn{c_{t_f} = 2 \mu_m}.
  }
  \item{isham:}{
    \eqn{t_f(m_x, m_y) = m_x m_y - \mu^2_m},
    \eqn{c_{t_f} = \sigma^2_m}.
  }
  \item{stoyancov:}{
    \eqn{t_f(m_x, m_y) = m_x m_y - \mu^2_m},
    \eqn{c_{t_f} = 1}.
  }
  \item{schlather:}{
    \eqn{t_f(m_x, m_y) = (m_x - \mu_m(r))(m_y - \mu_m(r))},
    \eqn{c_{t_f} = \sigma^2_m}.
  }
}
For \code{ftype="schlather"}, \eqn{\mu_m(r)} denotes the mean of the marks of all pairs of points whose pairwise distance lies within a tolerance \code{tol} of \eqn{r}.
We refer to Eckardt and Moradi (2024) for details of these mark correlation functions.

Regarding the smoothing functions, if \code{method="density"}, the functions \code{\link[spatstat.univar]{unnormdensity}} will be called, and if \code{method="loess"}, the function \code{\link[stats]{loess}} will be called.

If your \code{ftype} is not one of the defaults, then you need to give your test function \eqn{t_f(m_1, m_2)} using the argument \code{f}. In this case, \code{normalise} should be set as \code{FALSE}, as only the unnormalised version will be calculated. Depending on the form of the test function \eqn{t_f(m_1, m_2)}, one can manually compute the normalisation factor.


If the point patten \eqn{X} has multiple real-valued marks, the function estimates the mark correlation function for each mark individually. In such case, marks are given as a \code{data.frame} whose columns represents different marks. The functions checks which columns are numeric, and for those the mark correlation function will be computed.
}
\examples{
 library(spatstat.linnet)
 library(spatstat.geom)
 X <- rpoislpp(10, simplenet)
 marks(X) <- runif(npoints(X), 1, 10)
 mcorr.lpp(X, ftype = "stoyan", method = "density")

}
\references{
Eckardt, M., & Moradi, M. (2024). Marked spatial point processes: current state and extensions to point processes on linear networks. Journal of Agricultural, Biological and Environmental Statistics, 29(2), 346-378.
}
\seealso{
\code{\link[markstat]{mcorr.ppp}}.
}
\author{
Mehdi Moradi \email{m2.moradi@yahoo.com} and Matthias Eckardt
}
