% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmcorr.ppp.R
\name{lmcorr.ppp}
\alias{lmcorr.ppp}
\title{Local mark correlation functions for homogeneous point patterns on Euclidean spaces.}
\usage{
\method{lmcorr}{ppp}(X,
ftype = c("variogram", "stoyan", "rcorr", "shimatani", "beisbart",
 "isham", "stoyancov", "schlather"),
r = NULL,
method = c("density","loess"),
normalise = TRUE,
f = NULL,
tol = 0.01,
...)
}
\arguments{
\item{X}{An object of class ppp.}

\item{ftype}{Type of the test function \eqn{t_f}. Currently any selection of \code{"variogram", "stoyan", "rcorr", "shimatani", "beisbart", "isham", "stoyancov", "schlather"}.}

\item{r}{Optional. The values of the argument \eqn{r} at which the mark correlation function should be evaluated.}

\item{method}{Type of smoothing, either \code{density} or \code{loess}. See details.}

\item{normalise}{If \code{normalise=FALSE}, only the numerator of the expression for the mark correlation function will be computed.}

\item{f}{Optional. Test function \eqn{t_f} used in the definition of the mark correlation function. If \code{ftype} is given, \eqn{t_f} should be \code{NULL}.}

\item{tol}{Tolerance used in the calculation of the conditional mean of the marks. This is used only if \code{ftype} is \code{schlather}.}

\item{...}{Arguments passed to \code{\link[spatstat.univar]{unnormdensity}} or \code{\link[stats]{loess}}.}
}
\value{
A \code{data.frame} where the first column contains the values of the argument \eqn{r} at which the mark correlation function is evaluated, and the remaining columns contain the estimated values of the mark correlation function for each data point; column names correspond to the IDs of the data points.
If there are multiple numeric marks, the result will instead be a list, with each element corresponding to one of the marks.
}
\description{
Local mark correlation functions for homogeneous point patterns on Euclidean spaces.
}
\details{
This function computes local mark correlation functions for a stationary point pattern in \eqn{\mathbb{R}^2}. See the details of test functions used in \code{\link[markstat]{mcorr.ppp}}. Technical details are given in Eckardt and Moradi (2025).
}
\examples{
 library(spatstat.geom)
 library(spatstat.random)
 X <- rpoispp(100)
 marks(X) <- runif(npoints(X),10,11)
 lmcorr.ppp(X, ftype = "stoyan", method = "density")
}
\references{
Eckardt, M., & Moradi, M. (2025). Local indicators of mark association for marked spatial point processes.
}
\seealso{
\code{\link[markstat]{mcorr.ppp}}.
}
\author{
Mehdi Moradi \email{m2.moradi@yahoo.com} and Matthias Eckardt
}
