% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toolstartmessage.R
\name{toolstartmessage}
\alias{toolstartmessage}
\title{Tool: Start message}
\usage{
toolstartmessage(functionCallString, level = NULL)
}
\arguments{
\item{functionCallString}{A string representing the function call that should be logged}

\item{level}{This argument allows to establish a hierarchy of print statements. The hierarchy is preserved for the
next vcat executions. Currently this setting can have 4 states: NULL (nothing will be changed), 0 (reset
hierarchies), "+" (increase hierarchy level by 1) and "-" (decrease hierarchy level by 1).}
}
\value{
A list containing diagnostic information required by \code{\link{toolendmessage}}.
}
\description{
This function writes a process start message (what function was called with which arguments) and stores the current
time, so the corresponding call to \code{\link{toolendmessage}} can calculate the elapsed time.
}
\examples{

innerFunction <- function() {
  startinfo <- madrat:::toolstartmessage("innerFunction(argumentsToPrint = 123)", "+")
  vcat(1, "inner")
  madrat:::toolendmessage(startinfo, "-")
}
outerFunction <- function() {
  startinfo <- madrat:::toolstartmessage("outerFunction()", "+")
  vcat(1, "outer")
  innerFunction()
  madrat:::toolendmessage(startinfo, "-")
}
outerFunction()
}
\seealso{
\code{\link{toolendmessage}}, \code{\link{vcat}}
}
\author{
Jan Philipp Dietrich, Pascal Sauer
}
