% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/madr.mcmc.r
\name{madr.mcmc}
\alias{madr.mcmc}
\title{Calculate model averaged double robust estimate using a pseudo-MC3 algorithm}
\usage{
madr.mcmc(Y, X, U, W = NULL, M = 1000, cut = 0.95)
}
\arguments{
\item{Y}{vector of the outcome}

\item{X}{vector of the treatment (0/1)}

\item{U}{matrix of covariates to be considered for inclusion/exclusion}

\item{W}{matrix of covariates that will be included in all models (optional)}

\item{M}{the number of MCMC iteration}

\item{cut}{cumulative probability of models to be retained for improved computational efficiency (1 retains all visited models)}
}
\value{
A list. The list contains the following named components:
\item{madr}{the model averaged double robust estimate}
\item{weight.ps}{a vector that contains the inclusion probability of each covariate in the propensity score model}
\item{weight.om}{a vector that contains the inclusion probability of each covariate in the outcome model}
}
\description{
This function uses a pseudo-MC3 algorithm to search the model space, then estimate a model averaged double robust estimate using the two-stage procedure for estimating model weights with tau=0.
}

