% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mStats.R
\name{summ}
\alias{summ}
\title{Summary statistics}
\usage{
summ(data, ..., by = NULL, na.rm = FALSE, digits = 1, detail = FALSE)
}
\arguments{
\item{data}{data.frame}

\item{...}{variable name or names of multiple variables}

\item{by}{variable name for bivariate analysis}

\item{na.rm}{logical: if \code{TRUE}, it removes observations with missing values.}

\item{digits}{specify rounding of numbers.}

\item{detail}{logical: if \code{TRUE}, it displays a full spectrum of
summary statistics such as inter-quartile range, and p-value from normality
test.}
}
\value{
A list with \code{summ} class containing three sets of data.frame type:
\enumerate{
\item summary result,
\item summary result without any format,
\item labels for corresponding variables.
}
}
\description{
\code{summ()} calculates and displays a variety of summary statistics.
If no variables are specified, summary statistics are calculated
for all the variables in the dataset.
}
\details{
It calculates seven number summary statistics, and p-values from relevant
statistical tests of association.

\strong{ANNOTATIONS}

\code{Obs} = Number of observations

\code{NA} = Number of observations with missing value

\code{Mean} = Mean

\code{Std.Dev} = Standard deviation

\code{Median} = Median value

\code{25\%} = First quartile or percentile

\code{75\%} = Third quartile or percentile

\code{Min} = Minimum value

\code{Max} = Maximum value

\code{Normal} = p-value from Shapiro-Wilk Normality Test

\strong{Grouped summary statistics}

If a strata variable \code{by} is specified, grouped summary statistics
are calculated. In addition, based on the levels of \code{by},
relevant statistical tests of association such as Student's t-test
and Wilcoxon, ANOVA and Kruskal-Wallis tests are calculated and their
associated p-values are displayed.

\strong{Tabulating the whole dataset}

This is helpful when the dataset has been processed and finalized.
The final dataset can be fed into the function without
inputting any variables. This automatically filters and generates
tables on variables with possible data types for summary statistics. These
data types include \code{numeric}, \code{double}, \code{integer}, and \code{logical}.

\strong{Using colon \code{:} to summarize multiple variables}

A colon separator \code{:} can be used to summarize variables more efficiently.

\strong{Labels}

Labels for corresponding variables are displayed below the
table.
}
\examples{

## Univariate summary statistics
summ(iris, Sepal.Length)
summ(iris, Sepal.Length:Petal.Width)

## Bivariate summary statistics
summ(iris, Sepal.Length:Petal.Width, by = Species)

\dontrun{
## Using the whole dataset
summ(iris)
summ(iris, by = Species)

## Detailed summary statistics
summ(iris, detail = TRUE)
summ(iris, by = Species, detail = TRUE)
}

}
\author{
Email: \email{dr.myominnoo@gmail.com}

Website: \url{https://myominnoo.github.io/}
}
