% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mkbo.R
\name{mkbo}
\alias{mkbo}
\title{Estimate the mKBO decomposition}
\usage{
mkbo(formula, group, w = NULL, data, group_fixed = TRUE, viewpoint = "group")
}
\arguments{
\item{formula}{A regression formula (as a string) specifying the outcome and explanatory variables.}

\item{group}{A string naming the grouping variable. This variable should be a factor, and the decomposition will be performed for each level of this factor.}

\item{w}{A string naming the variable in \code{data} that contains observation weights. If \code{NULL}, equal weights are used.}

\item{data}{A \code{data.frame} or \code{tibble} containing the microdata. The data must not contain missing values in any of the variables used in the decomposition.}

\item{group_fixed}{Logical. If \code{TRUE} (default), group fixed effects are included in the pooled model used to estimate the sample-level coefficients.}

\item{viewpoint}{Character. Either \code{"group"}or \code{"sample"}. Specifies the decomposition perspective:
\itemize{
  \item \code{"group"}: How would group outcomes change if they had the endowments/coefficient structure of the full sample?
  \item \code{"sample"}: How do group characteristics differ from the sample, and how much does this explain outcome differences?
}}
}
\value{
An object of class \code{"mkbo"}, which is a list containing:
\describe{
  \item{\code{RECI}}{A tibble summarizing the mean outcome per group (M), mean difference from the reference (D), and contributions from endowments (E), coefficients (C), and interactions (I).}
  \item{\code{E_var}}{A data frame detailing variable-level contributions to the endowments (E) component.}
  \item{\code{C_var}}{A data frame detailing variable-level contributions to the coefficients (C) component.}
  \item{\code{I_var}}{A data frame detailing variable-level contributions to the interaction (I) component.}
}
}
\description{
This is the main function, computing the multi-group Kitagawa-Blinder-Oaxaca decomposition
}
\details{
The function performs group-wise regressions and compares them to a pooled regression model. It decomposes the differences in group means of the dependent variable into parts due to differences in observed characteristics (endowments), differences in how those characteristics translate into outcomes (coefficients), and the interaction of both.

The choice of \code{viewpoint} changes whether the decomposition is anchored on the sample or group averages, and this influences the interpretation of each component.

Group-specific coefficients are augmented with treatment contrasts to match the pooled model structure.
}
\examples{
mkbo_output <- mkbo("PERNP ~ BACHELOR", group = "RACE", data=pums_subset)
}
