% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ThreeMapComparison.R
\docType{methods}
\name{ThreeMapComparison}
\alias{ThreeMapComparison}
\alias{ThreeMapComparison,Model,ANY,ANY-method}
\alias{ThreeMapComparison,RasterLayer,RasterLayer,RasterLayer-method}
\title{Evaluate allocation performance with three maps}
\usage{
ThreeMapComparison(x, x1, y1, ...)

\S4method{ThreeMapComparison}{Model,ANY,ANY}(x, x1, y1, factors, timestep, ...)

\S4method{ThreeMapComparison}{RasterLayer,RasterLayer,RasterLayer}(x, x1, y1,
  factors, categories, labels, ...)
}
\arguments{
\item{x}{either a RasterLayer of observed land use at time 0 or an object
inheriting from class \code{Model}}

\item{x1}{a RasterLayer of observed land use at a subsequent time. Only
required if \code{x} is also a RasterLayer}

\item{y1}{a RasterLayer of simulated land use corresponding to \code{x1}. Only
required if \code{x} is also a RasterLayer}

\item{\dots}{additional arguments to \code{raster::\link[raster]{aggregate}}}

\item{factors}{numeric vector of aggregation factors (equivalent to the 'fact'
argument to \cr
\code{raster::\link[raster]{aggregate}} representing the resolutions at which
model performance should be tested}

\item{timestep}{numeric value indicating the timestep of the simulated land use
map. Only required if \code{x} is a \code{Model} object}

\item{categories}{numeric vector of land use categories in observed maps. Only
required if \code{x} is a RasterLayer}

\item{labels}{character vector (optional) with labels corresponding to
\code{categories}. Only required if \code{x} is a RasterLayer}
}
\value{
A \code{ThreeMapComparison} object.
}
\description{
An implementation of the method described by Pontius et al. (2011), which
compares a reference map at time 1, a reference map at time 2 and a simulated
map at time 2 to evaluate allocation performance at multiple resolutions while
taking into account persistence. The method quantifies disagreement within
coarse squares (minor allocation disagreement), disagreement between coarse
squares (major allocation disagreement), disagreement about the quantity of
land use change and agreement.
}
\examples{

## see lulcc-package examples
}
\references{
Pontius Jr, R.G., Peethambaram, S., Castella, J.C. (2011).
Comparison of three maps at multiple resol utions: a case study of land change
simulation in Cho Don District, Vietnam. Annals of the Association of American
Geographers 101(1): 45-62.
}
\seealso{
\code{\link{AgreementBudget}}, \code{\link{FigureOfMerit}},
\code{raster::\link[raster]{aggregate}}
}
