% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lucas.r
\name{Recode_vars}
\alias{Recode_vars}
\title{Update values to fit 2018}
\usage{
Recode_vars(con, csv, years, nonHarmonizeableVars)
}
\arguments{
\item{con}{Connection to db}

\item{csv}{CSV file that holds the pre-prepared variable mappings}

\item{years}{Numeric vector of years to be harmonised}

\item{nonHarmonizeableVars}{Characer vector of variables that cannot be harmonized between the years. These pertain to the variables which have been collected at the earlier stages (before 2018) of survey as ordered categorical variables, and at later stages (at and later than (?) 2018) - as discrete numbers. Such attributes are lc1/2_perc, lu1/2_perc and soil_stones_perc.}
}
\description{
Updates values in all tables to fit the last survey (2018) in terms of the coding of different variables; update is based on pre-made mappings
}
\examples{
\dontrun{
Recode_vars(con, '/data/LUCAS_harmo/data/mappings/RecodeVars.csv', c(2006, 2009, 2012, 2015, 2018))}
}
\seealso{
To create the conection please see \link[lucas]{Connect_to_db}
}
