% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/municipalities.R
\docType{data}
\name{Potucky_KV_cz}
\alias{Potucky_KV_cz}
\title{Municipal Election Data: Potucky (KV, CZ)}
\format{
An object of class \code{data.frame} with 130 rows and 14 columns.
}
\source{
The dataset was compiled primarily from official election results published by
the Czech Statistical Office. Additional contextual or verification information
(such as post-election roles) was obtained from publicly available municipal
records.
\itemize{
\item \href{https://www.volby.cz/index_en.htm}{Czech Statistical Office}
\item \href{https://www.potucky-obec.cz/}{Municipality website}
}
}
\usage{
Potucky_KV_cz
}
\description{
A dataset containing individual-level candidacy records from municipal
elections in the municipality of Potucky (district Karlovy Vary, Czech
Republic).
}
\details{
\tabular{ll}{
   \strong{Dataset overview:} \tab  \cr
   Municipality: \tab Potucky \cr
   District: \tab Karlovy Vary \cr
   Country: \tab Czech Republic \cr
   Number of elections: \tab 8 \cr
   Elections covered: \tab 1994, 1998, 2002, 2006, 2010, 2014, 2018, 2022 \cr
   Number of candidacies (rows): \tab 130 \cr
   Note: \tab \href{https://www.potucky-obec.cz/}{Municipality website} \cr
}
}
\section{Description of variables}{
\tabular{ll}{
   \strong{Variable} \tab \strong{Description} \cr
   elections \tab Election identifiers (numeric) \cr
   candidate \tab Candidate's full name (character) \cr
   list_name \tab Name of the candidate list (character) \cr
   list_pos \tab Candidate's position on the list (numeric) \cr
   pref_votes \tab Number of preferential votes (numeric) \cr
   elected \tab Logical; TRUE if candidate was elected \cr
   nom_party \tab Nominating party (character) \cr
   pol_affil \tab Political affiliation (character) \cr
   mayor \tab TRUE if elected mayor \cr
   dep_mayor \tab TRUE if elected deputy mayor \cr
   board \tab TRUE if member of the executive board \cr
   gov_support \tab TRUE if supported the local government \cr
   elig_voters \tab Number of eligible voters (numeric) \cr
   ballots_cast \tab Number of ballots cast (numeric) \cr
}


Each record describes one candidate's run for office, including their candidate
list affiliation, position on the list, nominating party, political affiliation,
number of preferential votes, and whether they were elected or held specific
positions (mayor, deputy mayor, member of the executive body).

The dataset also includes contextual election-level information, such as the
number of eligible voters and ballots cast, which can be used to calculate
voter turnout and related indicators. These variables appear only once per
election and constituency (they may be stored in a single candidate row for
that election/constituency)
}

\examples{
# Basic inspection
str(Potucky_KV_cz)

# Example of a basic continuity diagram (unformatted version)
\donttest{plot_continuity(Potucky_KV_cz, elections = "2010-", lists = "elected")}
}
\references{
\itemize{
\item Hornek, J. (2017). Komunalni politika v malych bohatych obcich v Ceske republice:
politicke souboje o zastupitelska kresla ci vsestranna kooperace ve prospech obci?
(Local Government in Small Rich Municipalities in the Czech Republic: Political
Battles for the Chairs of Representatives or Versatile Cooperation for the Benefits
of Municipalities?). \emph{Scientia et Societas}, 13(4), 115-143.
[\href{https://www.sets.cz/index.php/ojs/issue/view/19}{Full text}]
}
}
\keyword{datasets}
