% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outlier_persistence.R
\name{persisting_outliers}
\alias{persisting_outliers}
\title{Computes outlier persistence for a range of significance values.}
\usage{
persisting_outliers(
  X,
  alpha = seq(0.01, 0.1, by = 0.01),
  st_qq = 0.9,
  scale = TRUE,
  num_steps = 20,
  old_version = FALSE
)
}
\arguments{
\item{X}{The input data in a matrix, data.frame, or tibble format. All
columns should be numeric.}

\item{alpha}{Grid of significance levels.}

\item{st_qq}{The starting quantile for death radii sequence. This will be
used to compute the starting bandwidth value.}

\item{scale}{If \code{TRUE}, the data is scaled. Default is \code{TRUE}. Which
scaling method is used depends on the \code{old_version} parameter.
See \code{\link{lookout}} for details.}

\item{num_steps}{The length of the bandwidth sequence.}

\item{old_version}{Logical indicator of which version of the algorithm to use.}
}
\value{
A list with the following components:
\item{\code{out}}{A 3D array of \code{N x num_steps x num_alpha} where
\code{N} denotes the number of observations, \code{num_steps} denote the
length of the bandwidth sequence, and \code{num_alpha} denotes the number of
significance levels. This is a binary array and the entries are set to 1 if
that observation is an outlier for that particular bandwidth and significance
level.}
\item{\code{bw}}{The set of bandwidth values.}
\item{\code{gpdparas}}{The GPD parameters used. }
\item{\code{lookoutbw}}{The bandwidth chosen by the algorithm \code{lookout}
using persistent homology.}
}
\description{
This function computes outlier persistence for a range of significance
values, using the algorithm lookout, an outlier detection method that uses
leave-one-out kernel density estimates and generalized Pareto distributions
to find outliers.
}
\examples{
X <- rbind(
  data.frame(
    x = rnorm(500),
    y = rnorm(500)
  ),
  data.frame(
    x = rnorm(5, mean = 10, sd = 0.2),
    y = rnorm(5, mean = 10, sd = 0.2)
  )
)
plot(X, pch = 19)
outliers <- persisting_outliers(X, scale = FALSE)
outliers
autoplot(outliers)
}
