% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulations.R
\name{lol.sims.mean_diff}
\alias{lol.sims.mean_diff}
\title{Mean Difference Simulation}
\usage{
lol.sims.mean_diff(
  n,
  d,
  rotate = FALSE,
  priors = NULL,
  K = 2,
  md = 1,
  subset = c(1),
  offdiag = 0,
  s = 1
)
}
\arguments{
\item{n}{the number of samples of the simulated data.}

\item{d}{the dimensionality of the simulated data.}

\item{rotate}{whether to apply a random rotation to the mean and covariance. With random rotataion matrix \code{Q}, \code{mu = Q*mu}, and \code{S = Q*S*Q}. Defaults to \code{FALSE}.}

\item{priors}{the priors for each class. If \code{NULL}, class priors are all equal. If not null, should be \code{|priors| = K}, a length \code{K} vector for \code{K} classes. Defaults to \code{NULL}.}

\item{K}{the number of classes. Defaults to \code{2}.}

\item{md}{the magnitude of the difference in the means in the specified subset of dimensions. Ddefaults to \code{1}.}

\item{subset}{the dimensions to have a difference in the means. Defaults to only the first dimension. \code{max(subset) < d}. Defaults to \code{c(1)}.}

\item{offdiag}{the off-diagonal elements of the covariance matrix. Should be < 1. \code{S_{ij} = offdiag} if \code{i != j}, or 1 if \code{i == j}. Defaults to \code{0}.}

\item{s}{the scaling parameter of the covariance matrix. S_{ij} = scaling*1 if i == j, or scaling*offdiag if i != j. Defaults to \code{1}.}
}
\value{
A list of class \code{simulation} with the following:
\item{X}{\code{[n, d]} the \code{n} data points in \code{d} dimensions as a matrix.}
\item{Y}{\code{[n]} the \code{n} labels as an array.}
\item{mus}{\code{[d, K]} the \code{K} class means in \code{d} dimensions.}
\item{Sigmas}{\code{[d, d, K]} the \code{K} class covariance matrices in \code{d} dimensions.}
\item{priors}{\code{[K]} the priors for each of the \code{K} classes.}
\item{simtype}{The name of the simulation.}
\item{params}{Any extraneous parameters the simulation was created with.}
}
\description{
A function for simulating data in which a difference in the means is present only in a subset of dimensions, and equal covariance.
}
\section{Details}{

For more details see the help vignette:
\code{vignette("sims", package = "lolR")}
}

\examples{
library(lolR)
data <- lol.sims.mean_diff(n=200, d=30)  # 200 examples of 30 dimensions
X <- data$X; Y <- data$Y
}
\author{
Eric Bridgeford
}
