% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_experiment.R
\name{run_experiment}
\alias{run_experiment}
\title{Run NetLogo BehaviorSpace experiment}
\usage{
run_experiment(
  model_path,
  setup_file = NULL,
  experiment = NULL,
  output = "table",
  other_arguments = NULL,
  timeout = Inf,
  tidy_output = TRUE
)
}
\arguments{
\item{model_path}{A \code{\link[base:character]{character}} string specifying the
path to the NetLogo model file (with extension \code{.nlogo}, \code{.nlogo3d},
\code{.nlogox}, or \code{.nlogox3d}).}

\item{setup_file}{(optional) A \code{\link[base:character]{character}} string
specifying the path to an
\href{https://en.wikipedia.org/wiki/XML}{XML}
file containing the experiment definition. This file can be created using
\code{\link[=create_experiment]{create_experiment()}} or exported from the NetLogo
\href{https://docs.netlogo.org/behaviorspace.html}{BehaviorSpace}
interface (default: \code{NULL}).}

\item{experiment}{(optional) A \code{\link[base:character]{character}} string
specifying the name of the experiment defined in the NetLogo model file
(default: \code{NULL}).}

\item{output}{(optional) A \code{\link[base:character]{character}} vector
specifying which output types to generate from the experiment. Valid
options are: \code{"table"}, \code{"spreadsheet"}, \code{"lists"}, and
\code{"statistics"}. At least one of \code{"table"} or \code{"spreadsheet"} must be
included. See the
\href{https://docs.netlogo.org/behaviorspace.html}{BehaviorSpace}
documentation on
\href{https://docs.netlogo.org/behaviorspace.html#run-options-formats}{formats}
for details about each output type (default: \code{c("table", "lists")}).}

\item{other_arguments}{(optional) A \code{\link[base:character]{character}} vector
specifying any additional command-line arguments to pass to the NetLogo
executable. For example, you can use \code{c("--threads 4")} to specify the
number of threads. See the \emph{Details} section for more information
(default: \code{NULL}).}

\item{timeout}{(optional) A \code{\link[base:numeric]{numeric}} value specifying the
maximum time (in seconds) to wait for the NetLogo process to complete. If
the process exceeds this time limit, it will be terminated, and the
function will return the available output up to that point. Use \code{Inf} for
no time limit (default: \code{Inf}).}

\item{tidy_output}{(optional) A \code{\link[base:logical]{logical}} flag indicating
whether to tidy the output data frames. If \code{TRUE},
output data frames are arranged according to
\href{https://r4ds.hadley.nz/data-tidy.html}{tidy data principles}.
If \code{FALSE}, only the default transformations from
\code{\link[readr:read_delim]{read_delim()}} and
\code{\link[janitor:clean_names]{clean_names()}} are applied to the output data
(default: \code{TRUE}).}
}
\value{
A \code{\link[base:list]{list}} containing the experiment results. The
\code{list} includes the following elements, depending on the values specified
in the \code{output} parameter:
\itemize{
\item \code{metadata}: A \code{\link[base:list]{list}} with metadata about the experiment
run (present in all cases).
\item \code{table}: A \code{\link[tibble:tibble]{tibble}} with the results of the
\href{https://docs.netlogo.org/behaviorspace.html#table-output}{\code{table}}
output.
\item \code{spreadsheet}: A \code{\link[base:list]{list}} with the results of the
\href{https://docs.netlogo.org/behaviorspace.html#spreadsheet-output}{\code{spreadsheet}}
output containing two elements:
\itemize{
\item \code{statistics}: A \code{\link[tibble:tibble]{tibble}} with data from the
output first section.
\item \code{data}: A \code{\link[tibble:tibble]{tibble}} with data from the
output second section.
}
\item \code{lists}: A \code{\link[tibble:tibble]{tibble}} with the results of the
\href{https://docs.netlogo.org/behaviorspace.html#lists-output}{\code{lists}}
output.
\item \code{statistics}: A \code{\link[tibble:tibble]{tibble}} with the results of the
\href{https://docs.netlogo.org/behaviorspace.html#statistics-output}{\code{statistics}}
output.
}
}
\description{
\code{run_experiment()} runs a NetLogo
\href{https://docs.netlogo.org/behaviorspace.html}{BehaviorSpace} experiment in
headless mode and returns a \code{\link[base:list]{list}} with results as \href{https://r4ds.hadley.nz/data-tidy.html}{tidy data frames}. It can be used with
\code{\link[=create_experiment]{create_experiment()}} to create and run experiments
on the fly, or with an existing experiment stored in the NetLogo model file.

To avoid issues with list parsing, \code{run_experiment()} includes support for
the special \href{https://docs.netlogo.org/behaviorspace.html#lists-output}{lists}
output format. If your experiment includes metrics that return NetLogo lists,
include \code{"lists"} in the \code{output} argument to capture this output. Columns
containing NetLogo lists are returned as \code{\link[base:character]{character}}
vectors.

The function tries to locate the NetLogo installation automatically.
This is usually successful, but if it fails, you will need to set it
manually. See the \emph{Details} section for more information.

For complete guidance on setting up and running experiments in NetLogo,
please refer to the
\href{https://docs.netlogo.org/behaviorspace.html}{BehaviorSpace Guide}.
}
\details{
\subsection{Setting the NetLogo Installation Path}{

If \code{run_experiment()} cannot find the NetLogo installation, you will need to
set the path manually using the \code{NETLOGO_HOME} environment variable. On
Windows, a typical path is something like \verb{C:\\Program Files\\NetLogo 7.0.3}.
You can set this variable temporarily in your R session with:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Sys.setenv(NETLOGO_HOME = "PATH/TO/NETLOGO/INSTALLATION")
}\if{html}{\out{</div>}}

or permanently by adding it to your
\href{https://rstats.wtf/r-startup.html#renviron}{\code{.Renviron}} file.

If even after setting the \code{NETLOGO_HOME} variable you still encounter issues,
try setting a \code{NETLOGO_CONSOLE} environment variable with the path to
the NetLogo executable or binary. On Windows, a typical path is something
like \verb{C:\\Program Files\\NetLogo 7.0.3\\NetLogo.exe}.
}

\subsection{NetLogo 3D}{

The function automatically detects whether the provided model is a 3D model
(based on the file extension) and adjusts the command-line arguments
accordingly. You do not need to set the \verb{--3D} flag to the
\code{other_arguments} parameter manually.
}

\subsection{Handling NetLogo Lists}{

NetLogo uses a specific syntax for lists (e.g., \code{"[1 2 3]"}) that is
incompatible with standard
\href{https://en.wikipedia.org/wiki/Comma-separated_values}{CSV} formats. To
address this, NetLogo provides a special output format called
\href{https://docs.netlogo.org/behaviorspace.html#lists-output}{lists} that
exports list metrics in a tabular structure. If your experiment includes
metrics that return NetLogo lists, include \code{"lists"} in the \code{output}
argument to capture this output. Columns containing NetLogo lists are
returned as \code{\link[base:character]{character}} vectors.

The \code{\link[=parse_netlogo_list]{parse_netlogo_list()}} function is available for
parsing NetLogo list values embedded in other outputs. However, we recommend
using it only when necessary, as it can be computationally intensive for
large datasets and may not handle all edge cases.
}

\subsection{Additional Command-Line Arguments}{

You can pass additional command-line arguments to the NetLogo executable
using the \code{other_arguments} parameter. This can be useful for specifying
options such as the number of
\href{https://en.wikipedia.org/wiki/Thread_(computing)}{threads}
to use or other NetLogo-specific flags.

For example, to specify the number of threads, you can use:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{run_experiment(
  model_path = "path/to/model.nlogox",
  setup_file = "path/to/experiment.xml",
  other_arguments = c("--threads 4")
)
}\if{html}{\out{</div>}}

There are a variety of command-line options available, but some are reserved
for internal use by \code{run_experiment()} and cannot be modified. These are:
\itemize{
\item \code{--headless}: Ensures NetLogo runs in headless mode.
\item \verb{--3D}: Specifies if the model is a 3D model (automatically set based on
the model file extension).
\item \code{--model}: Specifies the path to the NetLogo model file.
\item \code{--setup-file}: Specifies the path to the experiment
\href{https://en.wikipedia.org/wiki/XML}{XML} file.
\item \code{--experiment}: Specifies the name of the experiment defined in the model.
\item \code{--table}: Specifies the output file for the
\href{https://docs.netlogo.org/behaviorspace.html#table-output}{table}
results.
\item \code{--spreadsheet}: Specifies the output file for the
\href{https://docs.netlogo.org/behaviorspace.html#spreadsheet-output}{spreadsheet}
results.
\item \code{--lists}: Specifies the output file for the
\href{https://docs.netlogo.org/behaviorspace.html#lists-output}{lists}
results.
\item \code{--stats}: Specifies the output file for the
\href{https://docs.netlogo.org/behaviorspace.html#statistics-output}{statistics}
results.
}

For a complete list of available options, refer to the
\href{https://docs.netlogo.org/behaviorspace.html#running-from-the-command-line}{BehaviorSpace Guide}.
}

\subsection{Non-Tabular Output}{

If the experiment generates any non-tabular output (e.g., prints, error
messages, warnings), it will be captured and displayed as an informational
message after the results data frame is returned. This allows you to see any
important messages generated during the experiment run. Keep in mind that
excessive non-tabular output may clutter your R console.
}
}
\examples{
# Defining the Model -----

\dontrun{
  # This model is included with NetLogo installations.
  model_path <-
    find_netlogo_home() |>
    file.path(
      "models",
      "IABM Textbook",
      "chapter 4",
      "Wolf Sheep Simple 5.nlogox"
    )
}

# Creating an Experiment -----

\dontrun{
  setup_file <- create_experiment(
    name = "Wolf Sheep Simple Model Analysis",
    repetitions = 10,
    sequential_run_order = TRUE,
    run_metrics_every_step = TRUE,
    setup = "setup",
    go = "go",
    time_limit = 1000,
    metrics = c(
      'count wolves',
      'count sheep'
    ),
    run_metrics_condition = NULL,
    constants = list(
      "number-of-sheep" = 500,
      "number-of-wolves" = list(
        first = 5,
        step = 1,
        last = 15
      ),
      "movement-cost" = 0.5,
      "grass-regrowth-rate" = 0.3,
      "energy-gain-from-grass" = 2,
      "energy-gain-from-sheep" = 5
    )
  )
}

# Running the Experiment -----

\dontrun{
  model_path |>
    run_experiment(
      setup_file = setup_file
    )
}

# Running an Experiment Defined in the NetLogo Model File -----

\dontrun{
  model_path |>
    run_experiment(
      experiment = "Wolf Sheep Simple model analysis"
    )
}
}
\seealso{
Other BehaviorSpace functions: 
\code{\link{create_experiment}()},
\code{\link{inspect_experiment}()},
\code{\link{read_experiment}()}
}
\concept{BehaviorSpace functions}
