% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_netlogo_color.R
\name{parse_netlogo_color}
\alias{parse_netlogo_color}
\title{Parse NetLogo colors}
\usage{
parse_netlogo_color(x, bias = 0.1)
}
\arguments{
\item{x}{A \code{\link[base:numeric]{numeric}} vector containing NetLogo color
codes (ranging from \code{0} to \code{140}) to be parsed into
\href{https://en.wikipedia.org/wiki/Web_colors}{hexadecimal color}
representations.}

\item{bias}{(optional) A \code{\link[base:numeric]{numeric}} value between \code{-1} and
\code{1} that adjusts the lightness or darkness of the resulting colors.
Positive values lighten colors, while negative values darken them. This
only affects shaded colors (those with shades other than \code{5})
(default: \code{0.1}).}
}
\value{
A \code{\link[base:character]{character}} vector containing the
approximate
\href{https://en.wikipedia.org/wiki/Web_colors}{hexadecimal color}
representations corresponding to the input NetLogo color codes.
}
\description{
\code{parse_netlogo_color()} parses NetLogo color codes into their approximate
\href{https://en.wikipedia.org/wiki/Web_colors}{hexadecimal color}
representations.

\strong{Note}: This function requires the
\href{https://colorspace.r-forge.r-project.org/}{\code{colorspace}},
and
\href{https://scales.r-lib.org/}{\code{scales}} packages.
}
\details{
NetLogo color codes are based on \code{14} hues, which can be visualized by
running
\href{https://docs.netlogo.org/dictionary.html#base-colors}{\code{base-colors}}
in the NetLogo console. Each hue can be adjusted using shades from \code{0} to
\code{9}, where \code{0} represents the darkest shade and \code{5} represents the base
shade. Shades \code{6} through \code{9} represent progressively lighter variations.

Note that NetLogo also supports extracting
\href{https://en.wikipedia.org/wiki/RGB_color_model}{RGB}
components directly with
\href{https://docs.netlogo.org/dictionary.html#extract-rgb}{\code{extract-rgb}}.
This function provides an alternative approach for obtaining color
representations from NetLogo color codes.
}
\examples{
# Simple Parsing Examples -----

netlogo_base_colors <- c(
  "gray" = 5,
  "red" = 15,
  "orange" = 25,
  "brown" = 35,
  "yellow" = 45,
  "green" = 55,
  "lime" = 65,
  "turquoise" = 75,
  "cyan" = 85,
  "sky" = 95,
  "blue" = 105,
  "violet" = 115,
  "magenta" = 125,
  "pink" = 135
)

parse_netlogo_color(netlogo_base_colors)

parse_netlogo_color(seq(10, 20, by = 1))

parse_netlogo_color(seq(10, 20, by = 0.5))

# Bias Adjustment Examples -----

parse_netlogo_color(17.5, bias = 0)

parse_netlogo_color(17.5, bias = -0.5)

parse_netlogo_color(17.5, bias = 0.5)
}
\seealso{
Other parsing functions: 
\code{\link{parse_netlogo_list}()}
}
\concept{parsing functions}
