% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logic.bagging.R, R/logic.boosting.R,
%   R/logicDT.R
\name{predict.logicDT}
\alias{predict.logicDT}
\alias{predict.logic.bagged}
\alias{predict.logic.boosted}
\alias{predict.genetic.logicDT}
\title{Prediction for logicDT models}
\usage{
\method{predict}{logic.bagged}(object, X, Z = NULL, type = "prob", ...)

\method{predict}{logic.boosted}(object, X, Z = NULL, type = "prob", ...)

\method{predict}{logicDT}(
  object,
  X,
  Z = NULL,
  type = "prob",
  ensemble = FALSE,
  leaves = "4pl",
  ...
)

\method{predict}{genetic.logicDT}(
  object,
  X,
  Z = NULL,
  models = "best",
  n_models = 10,
  ensemble = NULL,
  leaves = "4pl",
  ...
)
}
\arguments{
\item{object}{Fitted \code{logicDT} model. Usually a product of a call
to \code{\link{logicDT}}.}

\item{X}{Matrix or data frame of binary input data. This
object should correspond to the binary matrix for fitting
the model.}

\item{Z}{Optional quantitative covariables supplied as a
matrix or data frame. Only used (and required) if the
model was fitted using them.}

\item{type}{Prediction type. This can either be \code{"prob"} for
probability estimates or \code{"class"} for (hard)
classification of binary responses. Ignored for regression.}

\item{...}{Parameters supplied to \code{\link{predict.logicDT}}}

\item{ensemble}{If the model was fitted using the inner
validation approach, shall the prediction be constructed
using the final validated ensemble (\code{TRUE}) or using the
single final tree (\code{FALSE})?}

\item{leaves}{If leaf regression models (such as four parameter logistic
models) were fitted, shall these models be used for the prediction
(\code{"4pl"}) or shall the constant leaf means be used
(\code{"constant"})?}

\item{models}{Which logicDT models fitted via
genetic programming shall be used for prediction?
\code{"best"} leads to the single best model in the final
generation, \code{"all"} uses the average over the final
generation and \code{"n_models"} uses the \code{n_models} best models.}

\item{n_models}{How many models shall be used if
\code{models = "n_models"} and genetic programming was employed?}
}
\value{
A numeric vector of predictions. For binary outcomes,
  this is a vector with estimates for \eqn{P(Y=1 \mid X = x)}.
}
\description{
Supply new input data for predicting the outcome with a fitted
logicDT model.
}
