% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_preparation.R
\name{build_custom_mapping}
\alias{build_custom_mapping}
\title{Build column name mappings}
\usage{
build_custom_mapping(data, language = "de", prompt_mapping = TRUE)
}
\arguments{
\item{data}{the custom dataframe for which the user wants to build a custom
mapping}

\item{language}{a character string representing the language in which the
columns will be displayed during the mapping prompt (\code{"de"} or
\code{"fr"} or \code{"it"} or \code{"en"})}

\item{prompt_mapping}{a boolean indicating whether the function prompts the
user for the exact mapping of his dataframe or whether the columns are
mapped automatically by order}
}
\value{
A named vector of characters, where the name indicates the column name in the
original data.frame and the value indicates the column name as used by the
standard analysis model.
}
\description{
\code{build_custom_mapping} creates a vector of column name mappings for the
user to read her or his custom dataframe
}
\details{
Builds a mapping from the custom column names of a given data.frame to the
variable names used in the standard analysis model. If \code{prompt_mapping}
is set to \code{TRUE}, the function prompts the mapping for each column
of the data.frame. If \code{prompt_mapping} is set to \code{FALSE}, the
mapping is built using the order of the columns of the given data.frame.
}
