% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_lslog.R
\name{summary.lslog}
\alias{summary.lslog}
\title{Summary of Logistic Load Shape}
\usage{
\method{summary}{lslog}(object, ... = NULL)
}
\arguments{
\item{object}{An object of class \code{lslog},
created by the function \code{\link{lslog}}.}

\item{...}{\code{NULL}. Used for S3 generic/method consistency.}
}
\value{
\code{NULL}. Prints the summary of the derived
load shape using linear method.
}
\description{
Print method for summarizing
\code{lslog} object
}
\note{
Same as \code{\link{print.lslog}}
}
\examples{
# ---------------------
loads <- ercot[ercot$Year == 2019, ]$COAST
logistic_loadshape <- lslog(loads, target_lf = 0.5, k = 0.5)
summary(logistic_loadshape)
# ---------------------
loads2 <- ercot[ercot$Year == 2019, ]$ERCOT
logistic_loadshape2 <- lslog(loads2, target_lf = 0.75, k = 1)
summary(logistic_loadshape2)



}
\seealso{
\code{\link{lslog}}
}
