% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clmdu.R
\name{clmdu}
\alias{clmdu}
\title{Cumulative Logistic (Restricted) MDU}
\usage{
clmdu(
  Y,
  X = NULL,
  S = 2,
  trace = FALSE,
  start = "svd",
  maxiter = 65536,
  dcrit = 1e-06
)
}
\arguments{
\item{Y}{An N times R ordinal matrix coded with integers 1,2,.. .}

\item{X}{An N by P matrix with predictor variables}

\item{S}{Positive number indicating the dimensionality of the solution}

\item{trace}{boolean to indicate whether the user wants to see the progress of the function (default=TRUE)}

\item{start}{either starting values (list with (U,V) or (B,V)) or way to compute them (svd, random, ca)}

\item{maxiter}{maximum number of iterations}

\item{dcrit}{convergence criterion}
}
\value{
Y Matrix Y from input

Xoriginal Matrix X from input

X Scaled X matrix

mx Mean values of X

sdx Standard deviations of X

ynames Variable names of responses

xnames Variable names of predictors

probabilities Estimated values of Y

m main effects

U matrix with coordinates for row-objects

B matrix with regression weight (U = XB)

V matrix with vectors for items/responses

iter number of main iterations from the MM algorithm

deviance value of the deviance at convergence
}
\description{
Cumulative Logistic (Restricted) MDU
}
\examples{
\dontrun{
data(dataExample_clmdu)
Y<-dataExample_clmdu
X<-dataExample_clmdu
output1 = clmdu(Y)
plot(output1)
plot(output1, circles = NULL)
summary(output1)

output2 = clmdu(Y = Y, X = X)
plot(output2, circles = c(1,2))
summary(output2)
}

}
