% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explain.R
\name{fit_explanation}
\alias{fit_explanation}
\title{Fit white box model to the simulated data.}
\usage{
fit_explanation(
  live_object,
  white_box = "regr.lm",
  kernel = gaussian_kernel,
  standardize = FALSE,
  selection = FALSE,
  response_family = "gaussian",
  predict_type = "response",
  hyperpars = list()
)
}
\arguments{
\item{live_object}{List return by add_predictions function.}

\item{white_box}{String, learner name recognized by mlr package.}

\item{kernel}{function which will be used to calculate distance between simulated
observations and explained instance.}

\item{standardize}{If TRUE, numerical variables will be scaled to have mean 0, variance 1
before fitting explanation model.}

\item{selection}{If TRUE, variable selection based on glmnet implementation of LASSO
will be performed.}

\item{response_family}{family argument to glmnet (and then glm) function.
Default value is "gaussian"}

\item{predict_type}{Argument passed to mlr::makeLearner() argument "predict.type".
Defaults to "response".}

\item{hyperpars}{Optional list of values of hyperparameteres of a model.}
}
\value{
List of class "live_explainer" that consists of
\item{data}{Dataset used to fit explanation model (may have less column than the original)}
\item{model}{Fitted explanation model}
\item{explained_instance}{Instance that is being explained}
\item{weights}{Weights used in model fitting}
\item{selected_variables}{Names of selected variables}
}
\description{
Fit white box model to the simulated data.
}
\examples{
\dontrun{
fitted_explanation <- fit_explanation(local_exploration1, "regr.lm", selection = TRUE)
}

}
