% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotly.R
\name{prepare_plotly_linking}
\alias{prepare_plotly_linking}
\title{Prepare Plotly for Linking}
\usage{
prepare_plotly_linking(plotly_obj, id_column, source)
}
\arguments{
\item{plotly_obj}{A plotly object created with plot_ly()}

\item{id_column}{Character string: name of the ID column in the data}

\item{source}{Character string: plotly source identifier}
}
\value{
Modified plotly object with linking parameters added
}
\description{
Utility function to automatically add required parameters to a plotly object
for reliable linking, regardless of plot structure (single/multiple traces).
}
\examples{
\donttest{
   library(plotly)

  # Sample data
  df <- data.frame(
    id = 1:5,
    value = c(10, 20, 15, 25, 30),
    group = c("A", "A", "B", "B", "C")
  )

  # Create a plotly scatter plot
  p <- plot_ly(
    data = df,
    x = ~value,
    y = ~id,
    color = ~group
  )

  # Prepare for linking (adds customdata and source)
  p <- prepare_plotly_linking(p, "id", "my_plot")

  # Print the plot object (for demonstration)
  print(p)
}
}
