% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anovaTable.R
\name{anovaTable}
\alias{anovaTable}
\title{ANOVA Table}
\usage{
anovaTable(object, ...)
}
\arguments{
\item{object}{lm or aov model object}

\item{...}{currently ignored}
}
\value{
Object of class anova and data.frame
}
\description{
Produces the overall ANOVA table where the model sum of squares are not partioned into their parts.
}
\examples{
data(depression)

## MLR model
modMLR <- lm(depress~trauma+control,data=depression)
anovaTable(modMLR)

## ANOVA model
depression$gender <- factor(depression$gender)
depression$history <- factor(depression$history)
modAOV  <- lm(depress~-1+gender+history+gender:history,data=depression)
anovaTable(modAOV)

}
