% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fundamental.R
\name{fundamental}
\alias{fundamental}
\title{Get Fundamental Data}
\usage{
fundamental(
  symbol = NULL,
  from = "2010-01-01",
  to = Sys.Date(),
  quarter = NULL,
  fields = NULL
)
}
\arguments{
\item{symbol}{The stock symbol for which fundamental data is requested.}

\item{from}{The start date for the data retrieval in 'YYYY-MM-DD' format.}

\item{to}{The end date for the data retrieval in 'YYYY-MM-DD' format.}

\item{quarter}{Optional; specify the quarter and year 'Q1-2023', 'Q2-2023', 'Q1-2024'... for quarterly data.}

\item{fields}{Optional; specify particular fields of interest like 'roe'.}
}
\value{
A data frame containing the requested fundamental data if successful, NULL otherwise.
}
\description{
Fetches fundamental data for a specified stock symbol and range of dates,
and for specified accounting quarter(s), using the Limex API. Authentication
is done via an API token stored in an environment variable 'LIMEX_API_TOKEN'.
}
\examples{
\dontrun{
  company_fundamental <- fundamental(symbol = "AAPL")
  universe <- fundamental(fields = 'pe-ratio',quarter = 'Q2-2023')
  hist_data <- fundamental(symbol = "AAPL",fields = 'pe-ratio')
}
}
