% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/events.R
\name{events}
\alias{events}
\title{Get Events}
\usage{
events(
  symbol = "AAPL",
  from = "2010-01-01",
  to = Sys.Date(),
  type = "dividends"
)
}
\arguments{
\item{symbol}{The stock symbol for which events data is requested.}

\item{from}{The start date for the data retrieval in 'YYYY-MM-DD' format.}

\item{to}{The end date for the data retrieval in 'YYYY-MM-DD' format.}

\item{type}{Type of the event to filter (e.g., 'dividends').}
}
\value{
A data frame containing the events data if the request is successful, NULL otherwise.
}
\description{
Retrieves events data for a specified stock symbol, filtered by event type and date range.
Utilizes the API token set as an environment variable 'LIMEX_API_TOKEN'.
}
\examples{
\dontrun{
  events_data <- events(symbol = "AAPL", from = "2023-01-01", to = "2024-01-01")
}
}
