% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effects.R
\name{lx_effect_flame}
\alias{lx_effect_flame}
\title{"Flame" effect}
\usage{
lx_effect_flame(
  period = 5,
  duration = 10^10,
  power_on = TRUE,
  fast = FALSE,
  selector = "all",
  token = lx_get_token()
)
}
\arguments{
\item{period}{This controls how quickly the flame runs. It is measured in seconds. A lower number means the animation is faster}

\item{duration}{How long the animation lasts for in seconds. Not specifying a duration makes the animation never stop. Specifying 0 makes the animation stop. Note that there is a known bug where the tile remains in the animation once it has completed if duration is nonzero.}

\item{power_on}{if TRUE (default), switch any selected device that is off to on before performing the effect.}

\item{fast}{Executes the query fast, without initial state checks and wait for no results. See \url{https://api.developer.lifx.com/docs/set-state}}

\item{selector}{'LIFX' api "selector" such as "all", "id:12345", or "location:kitchen". Can be created with \code{\link{lx_selector}} or written manually (see \url{https://api.developer.lifx.com/docs/selectors}}

\item{token}{API token (see ?lx_save_token). If left empty, the token is retrieved from the environmental variable if available. (see \code{\link{lx_save_token}})}
}
\value{
an 'httr' response object (see \code{\link[httr]{response}})
}
\description{
"Flame" effect
}
\examples{
\dontrun{
lx_effect_flame(period = 2, duration = 3)
}
}
