% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exported_functions.R
\name{lib_startup}
\alias{lib_startup}
\title{Set packages and library paths to automatically start-up with R}
\usage{
lib_startup(..., lib = lib_paths(), global = TRUE)
}
\arguments{
\item{...}{(Names) Packages as bare names. For packages that come from GitHub, you can
keep the username/package format, or omit the username and provide just the package
name. If you leave \code{...} blank, R will only load its default packages (see Details).}

\item{lib}{(Character) The path where packages are installed. Can be an
absolute or relative path. If \code{path} has more than one element, only the first
one will be kept. Tilde expansion is performed on the input, but wildcard expansion
(globbing) is not. Defaults to the current library search path.}

\item{global}{(Logical) If \code{TRUE}, write these settings to a .Rprofile file in the home
directory (on Windows, the My Documents folder). If \code{FALSE}, write them to a
.Rprofile file that is in the current directory (i.e. the RStudio project's folder,
or the current working directory). See Details for more.}
}
\value{
A message listing the values that were written to the .Rprofile file.
}
\description{
This function tells R to load packages and library folders at the start of every
session (or on a per-project basis). It's best to keep this auto-load list to a
minimum so that you don't forget to explicitly install/attach packages in scripts
that need them.
}
\details{
R's startup order is mentioned in \code{?Startup}, but briefly:
\enumerate{
\item R tries to load the environmental variables file (Renviron.site)
\item R tries to load the site-wide profile (Rprofile.site)
\item R tries to load the user profile (.Rprofile), first in the current directory, and
then in the user's home directory (on Windows, the My Documents folder).
\strong{Only one of these files is sourced into the workspace.}
}

Omitting \code{...} makes R load only its default packages. If these are not set in an
environmental variable (\code{R_DEFAULT_PACKAGES}), then R will default to loading these
packages: datasets, utils, grDevices, graphics, stats, and methods.
}
\examples{
\donttest{
#> lib_startup(librarian, magrittr, lib = "C:/Dropbox/My R Library")
}

}
