% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HelperFunctions.R
\name{get_B}
\alias{get_B}
\title{Get Constrained GLM Coefficient Estimates}
\usage{
get_B(
  X,
  X_gram,
  Lambda,
  keep_weighted_Lambda,
  unique_penalty_per_partition,
  L_partition_list,
  A,
  Xy,
  y,
  K,
  nc,
  nca,
  Ghalf,
  GhalfInv,
  parallel_eigen,
  parallel_aga,
  parallel_matmult,
  parallel_unconstrained,
  cl,
  chunk_size,
  num_chunks,
  rem_chunks,
  family,
  unconstrained_fit_fxn,
  iterate,
  qp_score_function,
  quadprog,
  qp_Amat,
  qp_bvec,
  qp_meq,
  prevB = NULL,
  prevUnconB = NULL,
  iter_count = 0,
  prev_diff = Inf,
  tol,
  constraint_value_vectors,
  order_list,
  glm_weight_function,
  shur_correction_function,
  need_dispersion_for_estimation,
  dispersion_function,
  observation_weights,
  homogenous_weights,
  return_G_getB,
  blockfit,
  just_linear_without_interactions,
  Vhalf,
  VhalfInv,
  ...
)
}
\arguments{
\item{X}{List of design matrices by partition}

\item{X_gram}{List of Gram matrices by partition}

\item{Lambda}{Combined penalty matrix (smoothing spline + ridge)}

\item{keep_weighted_Lambda}{Logical; retain GLM weights in smoothing spline penalty}

\item{unique_penalty_per_partition}{Logical; whether to use partition-specific penalties}

\item{L_partition_list}{List of partition-specific penalty matrices}

\item{A}{Matrix of smoothness constraints (continuity, differentiability)}

\item{Xy}{List of X^T y products by partition}

\item{y}{List of responses by partition}

\item{K}{Integer; number of knots (partitions = K+1)}

\item{nc}{Integer; number of coefficients per partition}

\item{nca}{Integer; number of columns in constraint matrix}

\item{Ghalf}{List of G^(1/2) matrices by partition}

\item{GhalfInv}{List of G^(-1/2) matrices by partition}

\item{parallel_eigen, parallel_aga, parallel_matmult, parallel_unconstrained}{Logical flags for parallel computation components}

\item{cl}{Cluster object for parallel processing}

\item{chunk_size, num_chunks, rem_chunks}{Parameters for chunking in parallel processing}

\item{family}{GLM family object (includes link function and variance functions)}

\item{unconstrained_fit_fxn}{Function for obtaining unconstrained estimates}

\item{iterate}{Logical; whether to use iterative optimization for non-linear links}

\item{qp_score_function}{Function; see description in \code{\link[lgspline]{lgspline}}. Accepts arguments in order "X, y, mu, order_list, dispersion, VhalfInv, ...".}

\item{quadprog}{Logical; whether to use quadratic programming for inequality constraints}

\item{qp_Amat, qp_bvec, qp_meq}{Quadratic programming constraint parameters}

\item{prevB}{List of previous coefficient estimates for warm starts}

\item{prevUnconB}{List of previous unconstrained coefficient estimates}

\item{iter_count, prev_diff}{Iteration tracking for convergence}

\item{tol}{Numeric; convergence tolerance}

\item{constraint_value_vectors}{List of additional constraint values}

\item{order_list}{List of observation orderings by partition}

\item{glm_weight_function}{Function for computing GLM weights}

\item{shur_correction_function}{Function for uncertainty corrections in information matrix}

\item{need_dispersion_for_estimation}{Logical; whether dispersion needs estimation}

\item{dispersion_function}{Function for estimating dispersion parameter}

\item{observation_weights}{Optional observation weights by partition}

\item{homogenous_weights}{Logical; whether weights are constant}

\item{return_G_getB}{Logical; whether to return G matrices with coefficient estimates}

\item{blockfit}{Logical; whether to use block-fitting approach for special structure}

\item{just_linear_without_interactions}{Vector of columns for non-spline effects}

\item{Vhalf, VhalfInv}{Square root and inverse square root correlation matrices for GEE fitting}

\item{...}{Additional arguments passed to fitting functions}
}
\value{
For `return_G_getB = FALSE`: A list of coefficient vectors by partition.

For `return_G_getB = TRUE`: A list with elements:
\describe{
  \item{B}{List of coefficient vectors by partition}
  \item{G_list}{List containing G matrices (covariance matrices), Ghalf (square root),
                and GhalfInv (inverse square root)}
}
}
\description{
Core estimation function for Lagrangian multiplier smoothing splines. Computes
coefficient estimates under smoothness constraints and penalties for GLMs, handling
four distinct computational paths depending on model structure.
}
\details{
This function implements the method of Lagrangian multipliers for fitting constrained
generalized linear models with smoothing splines. The function follows one of four main
computational paths depending on the model structure:

\bold{1. Pure GEE (No Blockfitting):}
When Vhalf and VhalfInv are provided without blockfitting, the function uses generalized
estimating equations to handle correlated data. The design matrix is arranged in
block-diagonal form, and the estimation explicitly accounts for the correlation structure
provided. Uses sequential quadratic programming (SQP) for optimization.

\bold{2. Blockfitting (With or Without Correlation):}
When blockfit=TRUE and linear-only terms are specified, the function separates spline effects
from linear-only terms. The design matrix is restructured with spline terms in block-diagonal
form and linear terms stacked together. This structure is particularly efficient when there
are many non-spline effects. The function can handle both correlated (GEE) and uncorrelated
data in this path.

\bold{3. Canonical Gaussian, No Correlation:}
For Gaussian family with identity link and no correlation structure, calculations are greatly
simplified. No unconstrained fit function is needed; estimation uses direct matrix operations.
This path takes advantage of the closed-form solution available for linear models with
Gaussian errors.

\bold{4. GLMs, No Correlation:}
For non-Gaussian GLMs without correlation structure, the function requires an unconstrained_fit_fxn
to obtain initial estimates. It may use iterative fitting for non-canonical links. This path
first computes unconstrained estimates for each partition, then applies constraints using the
method of Lagrangian multipliers.

All paths use efficient matrix decompositions and avoid explicitly constructing full matrices
when possible. For non-canonical links, iterative fitting is employed to converge to the optimal
solution.
}
\keyword{internal}
