% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering-methods.R
\name{HierarchicalClustering}
\alias{HierarchicalClustering}
\title{Hierarchical Clustering}
\value{
R6 Class of HierarchicalClustering
}
\description{
Wrapper R6 Class of stats::hclust function that can be used for LESSRegressor and LESSClassifier
}
\examples{

## ------------------------------------------------
## Method `HierarchicalClustering$new`
## ------------------------------------------------

hc <- HierarchicalClustering$new()
hc <- HierarchicalClustering$new(n_clusters = 10)
hc <- HierarchicalClustering$new(n_clusters = 10, linkage = "complete")

## ------------------------------------------------
## Method `HierarchicalClustering$fit`
## ------------------------------------------------

data(abalone)
hc <- HierarchicalClustering$new()
hc$fit(abalone[1:100,])

## ------------------------------------------------
## Method `HierarchicalClustering$get_cluster_centers`
## ------------------------------------------------

print(hc$get_cluster_centers())

## ------------------------------------------------
## Method `HierarchicalClustering$get_labels`
## ------------------------------------------------

print(hc$get_labels())
}
\seealso{
\code{\link[stats:hclust]{stats::hclust()}}
}
\section{Super class}{
\code{\link[less:BaseEstimator]{less::BaseEstimator}} -> \code{HierarchicalClustering}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-HierarchicalClustering-new}{\code{HierarchicalClustering$new()}}
\item \href{#method-HierarchicalClustering-fit}{\code{HierarchicalClustering$fit()}}
\item \href{#method-HierarchicalClustering-get_cluster_centers}{\code{HierarchicalClustering$get_cluster_centers()}}
\item \href{#method-HierarchicalClustering-get_labels}{\code{HierarchicalClustering$get_labels()}}
\item \href{#method-HierarchicalClustering-clone}{\code{HierarchicalClustering$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="less" data-topic="BaseEstimator" data-id="get_all_fields"><a href='../../less/html/BaseEstimator.html#method-BaseEstimator-get_all_fields'><code>less::BaseEstimator$get_all_fields()</code></a></span></li>
<li><span class="pkg-link" data-pkg="less" data-topic="BaseEstimator" data-id="get_attributes"><a href='../../less/html/BaseEstimator.html#method-BaseEstimator-get_attributes'><code>less::BaseEstimator$get_attributes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="less" data-topic="BaseEstimator" data-id="set_random_state"><a href='../../less/html/BaseEstimator.html#method-BaseEstimator-set_random_state'><code>less::BaseEstimator$set_random_state()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HierarchicalClustering-new"></a>}}
\if{latex}{\out{\hypertarget{method-HierarchicalClustering-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of R6 Class of HierarchicalClustering
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HierarchicalClustering$new(linkage = "ward.D2", n_clusters = 8)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{linkage}}{the agglomeration method to be used. This should be (an unambiguous abbreviation of) one of
"ward.D", "ward.D2", "single", "complete", "average" (= UPGMA), "mcquitty" (= WPGMA), "median" (= WPGMC) or "centroid" (= UPGMC)
(defaults to ward.D2).}

\item{\code{n_clusters}}{the number of clusters (defaults to 8).}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{hc <- HierarchicalClustering$new()
hc <- HierarchicalClustering$new(n_clusters = 10)
hc <- HierarchicalClustering$new(n_clusters = 10, linkage = "complete")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HierarchicalClustering-fit"></a>}}
\if{latex}{\out{\hypertarget{method-HierarchicalClustering-fit}{}}}
\subsection{Method \code{fit()}}{
Perform hierarchical clustering on a data matrix.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HierarchicalClustering$fit(X)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X}}{numeric matrix of data, or an object that can be coerced to such a matrix (such as a numeric vector or a data frame with all numeric columns).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Fitted R6 class of HierarchicalClustering() that has 'labels' attribute
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{data(abalone)
hc <- HierarchicalClustering$new()
hc$fit(abalone[1:100,])
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HierarchicalClustering-get_cluster_centers"></a>}}
\if{latex}{\out{\hypertarget{method-HierarchicalClustering-get_cluster_centers}{}}}
\subsection{Method \code{get_cluster_centers()}}{
Auxiliary function returning the cluster centers
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HierarchicalClustering$get_cluster_centers()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{print(hc$get_cluster_centers())
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HierarchicalClustering-get_labels"></a>}}
\if{latex}{\out{\hypertarget{method-HierarchicalClustering-get_labels}{}}}
\subsection{Method \code{get_labels()}}{
Auxiliary function returning a vector of integers (from 1:k) indicating the cluster to which each point is allocated.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HierarchicalClustering$get_labels()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{print(hc$get_labels())
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HierarchicalClustering-clone"></a>}}
\if{latex}{\out{\hypertarget{method-HierarchicalClustering-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HierarchicalClustering$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
