% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classifiers.R
\name{DecisionTreeClassifier}
\alias{DecisionTreeClassifier}
\title{DecisionTreeClassifier}
\value{
R6 Class of DecisionTreeClassifier
}
\description{
Wrapper R6 Class of rpart::rpart function that can be used for LESSRegressor and LESSClassifier
}
\examples{

## ------------------------------------------------
## Method `DecisionTreeClassifier$new`
## ------------------------------------------------

dt <- DecisionTreeClassifier$new()
dt <- DecisionTreeClassifier$new(min_samples_split = 10)
dt <- DecisionTreeClassifier$new(min_samples_leaf = 6, cp = 0.01)

## ------------------------------------------------
## Method `DecisionTreeClassifier$fit`
## ------------------------------------------------

data(iris)
split_list <- train_test_split(iris, test_size =  0.3)
X_train <- split_list[[1]]
X_test <- split_list[[2]]
y_train <- split_list[[3]]
y_test <- split_list[[4]]

dt <- DecisionTreeClassifier$new()
dt$fit(X_train, y_train)

## ------------------------------------------------
## Method `DecisionTreeClassifier$predict`
## ------------------------------------------------

dt <- DecisionTreeClassifier$new()
dt$fit(X_train, y_train)
preds <- dt$predict(X_test)

dt <- DecisionTreeClassifier$new()
preds <- dt$fit(X_train, y_train)$predict(X_test)

preds <- DecisionTreeClassifier$new()$fit(X_train, y_train)$predict(X_test)
print(caret::confusionMatrix(data=preds, reference = factor(y_test)))

## ------------------------------------------------
## Method `DecisionTreeClassifier$get_estimator_type`
## ------------------------------------------------

dt$get_estimator_type()
}
\seealso{
\code{\link[rpart:rpart]{rpart::rpart()}}
}
\section{Super classes}{
\code{\link[less:BaseEstimator]{less::BaseEstimator}} -> \code{\link[less:SklearnEstimator]{less::SklearnEstimator}} -> \code{DecisionTreeClassifier}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-DecisionTreeClassifier-new}{\code{DecisionTreeClassifier$new()}}
\item \href{#method-DecisionTreeClassifier-fit}{\code{DecisionTreeClassifier$fit()}}
\item \href{#method-DecisionTreeClassifier-predict}{\code{DecisionTreeClassifier$predict()}}
\item \href{#method-DecisionTreeClassifier-get_estimator_type}{\code{DecisionTreeClassifier$get_estimator_type()}}
\item \href{#method-DecisionTreeClassifier-clone}{\code{DecisionTreeClassifier$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="less" data-topic="BaseEstimator" data-id="get_all_fields"><a href='../../less/html/BaseEstimator.html#method-BaseEstimator-get_all_fields'><code>less::BaseEstimator$get_all_fields()</code></a></span></li>
<li><span class="pkg-link" data-pkg="less" data-topic="BaseEstimator" data-id="get_attributes"><a href='../../less/html/BaseEstimator.html#method-BaseEstimator-get_attributes'><code>less::BaseEstimator$get_attributes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="less" data-topic="BaseEstimator" data-id="set_random_state"><a href='../../less/html/BaseEstimator.html#method-BaseEstimator-set_random_state'><code>less::BaseEstimator$set_random_state()</code></a></span></li>
<li><span class="pkg-link" data-pkg="less" data-topic="SklearnEstimator" data-id="get_isFitted"><a href='../../less/html/SklearnEstimator.html#method-SklearnEstimator-get_isFitted'><code>less::SklearnEstimator$get_isFitted()</code></a></span></li>
<li><span class="pkg-link" data-pkg="less" data-topic="SklearnEstimator" data-id="get_type"><a href='../../less/html/SklearnEstimator.html#method-SklearnEstimator-get_type'><code>less::SklearnEstimator$get_type()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DecisionTreeClassifier-new"></a>}}
\if{latex}{\out{\hypertarget{method-DecisionTreeClassifier-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of R6 Class of DecisionTreeClassifier
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DecisionTreeClassifier$new(
  min_samples_split = 2,
  min_samples_leaf = 1,
  cp = 0.001,
  xval = 10,
  surrogate_style = 0,
  max_depth = 30
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{min_samples_split}}{The minimum number of observations that must exist in a node in order for a split to be attempted (defaults to 2).}

\item{\code{min_samples_leaf}}{The minimum number of observations in any terminal (leaf) node (defaults to 1).}

\item{\code{cp}}{Complexity Parameter. Any split that does not decrease the overall lack of fit by a factor of cp is not attempted.
This means that the overall R-squared must increase by cp at each step. The main role of this parameter is
to save computing time by pruning off splits that are obviously not worthwhile. (defaults to 0.001)}

\item{\code{xval}}{Number of cross-validations (defaults to 10)}

\item{\code{surrogate_style}}{Controls the selection of a best surrogate. If set to 0 (default) the program uses the total number of correct
classification for a potential surrogate variable, if set to 1 it uses the percent correct, calculated over the non-missing values of the surrogate.
The first option more severely penalizes covariates with a large number of missing values.}

\item{\code{max_depth}}{The maximum depth of any node of the final tree, with the root node counted as depth 0.
Values greater than 30 will give nonsense results on 32-bit machines.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{dt <- DecisionTreeClassifier$new()
dt <- DecisionTreeClassifier$new(min_samples_split = 10)
dt <- DecisionTreeClassifier$new(min_samples_leaf = 6, cp = 0.01)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DecisionTreeClassifier-fit"></a>}}
\if{latex}{\out{\hypertarget{method-DecisionTreeClassifier-fit}{}}}
\subsection{Method \code{fit()}}{
Builds a decision tree regressor from the training set (X, y).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DecisionTreeClassifier$fit(X, y)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X}}{2D matrix or dataframe that includes predictors}

\item{\code{y}}{1D vector or (n,1) dimensional matrix/dataframe that includes labels}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Fitted R6 Class of DecisionTreeClassifier
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{data(iris)
split_list <- train_test_split(iris, test_size =  0.3)
X_train <- split_list[[1]]
X_test <- split_list[[2]]
y_train <- split_list[[3]]
y_test <- split_list[[4]]

dt <- DecisionTreeClassifier$new()
dt$fit(X_train, y_train)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DecisionTreeClassifier-predict"></a>}}
\if{latex}{\out{\hypertarget{method-DecisionTreeClassifier-predict}{}}}
\subsection{Method \code{predict()}}{
Predict regression value for X0.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DecisionTreeClassifier$predict(X0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X0}}{2D matrix or dataframe that includes predictors}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Factor of the predict classes.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{dt <- DecisionTreeClassifier$new()
dt$fit(X_train, y_train)
preds <- dt$predict(X_test)

dt <- DecisionTreeClassifier$new()
preds <- dt$fit(X_train, y_train)$predict(X_test)

preds <- DecisionTreeClassifier$new()$fit(X_train, y_train)$predict(X_test)
print(caret::confusionMatrix(data=preds, reference = factor(y_test)))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DecisionTreeClassifier-get_estimator_type"></a>}}
\if{latex}{\out{\hypertarget{method-DecisionTreeClassifier-get_estimator_type}{}}}
\subsection{Method \code{get_estimator_type()}}{
Auxiliary function returning the estimator type e.g 'regressor', 'classifier'
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DecisionTreeClassifier$get_estimator_type()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{dt$get_estimator_type()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DecisionTreeClassifier-clone"></a>}}
\if{latex}{\out{\hypertarget{method-DecisionTreeClassifier-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DecisionTreeClassifier$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
