% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lepidochroma_display.R
\name{lepidochroma_display}
\alias{lepidochroma_display}
\title{Palette preview}
\usage{
lepidochroma_display(
  name = NULL,
  n = NULL,
  type = c("all", "discrete", "continuous"),
  colourblind_only = FALSE
)
}
\arguments{
\item{name}{Palette name (see the \code{name} column in the data frame
returned by \code{lepidochroma_palettes()} for a list of available
options).  This argument is case insensitive.  If it is not
specified, all palettes matching the properties indicated in the
\code{type} and \code{colourblind_only} arguments will be displayed.}

\item{n}{Number of colours to display.  It is an optional argument,
if it is not specified, the plot will display all the available
colours.}

\item{type}{The type of palettes to be displayed (\code{"all"},
\code{"discrete"}, or \code{"continuous"}).  This argument is ignored if
\code{name} is specified.  It defaults to \code{"all"}.}

\item{colourblind_only}{A logical value.  If \code{TRUE}, display only
colour blind friendly palettes.  This argument is ignored if
\code{name} is specified.  It defaults to \code{FALSE}.}
}
\value{
No return value, called for side effects.
}
\description{
Displays a preview of a palette or a set of palettes with the
specified number of colours in a plot.
}
\examples{
# Discrete palette
lepidochroma_display("parthenos", 3)
# Continuous palette
lepidochroma_display("battus", 30)

}
