% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{predict_leapGP}
\alias{predict_leapGP}
\title{Predict Method for leapGP}
\usage{
predict_leapGP(
  object,
  newdata,
  rho = 0.95,
  scale = FALSE,
  n = ceiling(sqrt(length(y))),
  start = NA,
  M_max = Inf,
  ...
)
}
\arguments{
\item{object}{An object of class \code{leapGP}}

\item{newdata}{New data}

\item{rho}{parameter controlling time-accuracy tradeoff (default is \code{rho=0.95})}

\item{scale}{logical. Do we want the scale parameter to be returned for predictions? If TRUE,
the matrix \eqn{K^{-1}} will be stored for each hub.}

\item{n}{local neighborhood size}

\item{start}{number of starting points for neighborhood (between 6 and n inclusive)}

\item{M_max}{the maximum number of hubs allowed (used to upper bound the run time)}

\item{...}{optional arguments to be passed to \code{laGP()}}
}
\value{
A list containing values \code{mean}, \code{hubs} \code{X} and \code{y}. If \code{scale=TRUE} the list also contains field \code{sd}.
}
\description{
Predict method for an object of class leapGP.
Returns a (possibly modified) leapGP object as well as a prediction (with uncertainty, if requested).
}
\details{
The leapGP is extends the laGP framework of Gramacy & Apley (2015). The methods are equivalent for \code{rho=1},
         but leapGP trades memory for speed when \code{rho < 1}. The method is described in Rumsey et al. (2023) where they demonstrate
         that leapGP is faster than laGP for sequential predictions and is also generally more accurate for some settings of \code{rho}.
}
\examples{
# Generate data
f <- function(x){
   1.3356*(1.5*(1-x[1]) + exp(2*x[1] - 1)*sin(3*pi*(x[1] - 0.6)^2) +
   exp(3*(x[2]-0.5))*sin(4*pi*(x[2] - 0.9)^2))
}
X <- matrix(runif(200), ncol=2)
y <- apply(X, 1, f)

# Generate data for prediction
Xtest <- matrix(runif(200), ncol=2)
ytest <- apply(Xtest, 1, f)

# Train initial model
mod <- leapGP(X, y, M0 = 30)
# Make sequential predictions
pred <- rep(NA, 100)
for(i in 1:100){
  mod <- predict_leapGP(mod, matrix(Xtest[i,], nrow=1), rho=0.9)
  pred[i] <- mod$mean
}
}
\references{
Gramacy, R. B., & Apley, D. W. (2015). Local Gaussian process approximation for large computer experiments. Journal of Computational and Graphical Statistics, 24(2), 561-578.

Rumsey, K. N., Huerta, G., & Derek Tucker, J. (2023). A localized ensemble of approximate Gaussian processes for fast sequential emulation. Stat, 12(1), e576.
}
