% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ldamatch.R
\name{.normalize_props}
\alias{.normalize_props}
\title{Normalizes the props parameter for match_groups().}
\usage{
.normalize_props(props, condition, keep_last_item = FALSE)
}
\arguments{
\item{props}{Either the desired proportions (percentage) of the
sample for each condition as a named vector,
or the names of the conditions
for which we prefer to preserve the subjects,
in decreasing order of preference. If not specified, the
(full) sample proportions are used.
This is preferred among configurations with the same
taken into account by the other methods to some extent.
For example, c(A = 0.4, B = 0.4, C = 0.2) means that
we would like the number of subjects in groups A, B, and
C to be around 40\%, 40\%, and 20\% of the total number of
subjects, respectively. Whereas c("A", "B", "C") means
that if possible, we would like to keep all subjects
in group A, and prefer keeping subjects in B, even if
it results in losing more subjects from C.}

\item{condition}{A factor vector containing condition labels.}

\item{keep_last_item}{If TRUE and props is a character vector, last item is not dropped.}
}
\value{
A named vector: if props contains proportions, it is the same, but
ordered to follow the levels of condition; if props contains names of
conditions, the total number of subjects for the condition names in props.
}
\description{
Normalizes the props parameter for match_groups().
}
\keyword{internal}
