% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ItemInfo.R
\name{ItemInfo}
\alias{ItemInfo}
\title{Conditional probabilities and item information given specified latent process values
for \code{lcmm} or \code{multlcmm}
object with ordinal outcomes.}
\usage{
ItemInfo(
  x,
  lprocess,
  condRE_Y = FALSE,
  nsim = 200,
  draws = FALSE,
  ndraws = 2000,
  ...
)
}
\arguments{
\item{x}{an object inheriting from class  \code{lcmm} or \code{multlcmm}, 
representing a general (latent class) mixed model.}

\item{lprocess}{numeric vector containing the latent process values at which the
predictions should be computed.}

\item{condRE_Y}{for multlcmm objects only, logical indicating if the predictions
are conditional to the outcome-specific random-effects or not. Default to FALSE=
the predictions are marginal to these random effects.}

\item{nsim}{number of points used in the numerical integration (Monte-Carlo) with
splines or Beta link functions. nsim should be relatively important
(nsim=200 by default).}

\item{draws}{optional boolean specifying whether median and confidence bands
of the predicted values should be computed (TRUE). A Monte Carlo approximation 
of the posterior distribution of the predicted values is computed and the median, 
2.5\% and 97.5\% percentiles are given. Otherwise, the predicted values are 
computed at the point estimate. By default, draws=FALSE.}

\item{ndraws}{if draws=TRUE, ndraws specifies the number of draws that should be
generated to approximate the posterior distribution of the predicted values.
By default, ndraws=2000.}

\item{\dots}{further arguments to be passed to or from other methods.  They
are ignored in this function.}
}
\value{
An object of class \code{ItemInfo} with values :

- \code{ItemInfo}: 
If draws=FALSE, returns a matrix with 3 columns: the first column indicates the
name of the outcome, the second indicates the latent process value and the last
is the computed Fisher information.
If draws=TRUE, returns a matrix with 5 columns: the name of the outcome, the
latent process value and the 50\%, 2.5\% and 97.5\% percentiles of the approximated
posterior distribution of information.

- \code{LevelInfo}: 
If draws=FALSE, returns a matrix with 5 columns: the first column indicates the
name of the outcome, the second indicates the outcome's level, the third indicates the
latent process value and the two last contain the probability and Fisher information.
If draws=TRUE, returns a matrix with 5 columns: the name of the outcome,
the outcome's level, the latent process value and the 50\%, 2.5\% and 97.5\%
percentiles of the approximated posterior distribution of the probability and information.

- \code{object}: the model from which the computations are done.

- \code{IC}: indicator specifying if confidence intervals are computed.
}
\description{
The function computes the conditional probability and information function of
each level of each ordinal outcome and the information function at the item level.
Confidence bands (and median) can be computed by a Monte Carlo approximation.
}
\examples{
\dontrun{
## This is a toy example to illustrate the information functions.
## The binary outcomes are arbitrarily created, please do not
## consider them as relevent indicators.
data_lcmm$Yord1 <- as.numeric(data_lcmm$Ydep1>10)
data_lcmm$Yord2 <- as.numeric(data_lcmm$Ydep2>25)
m <- multlcmm(Yord1+Yord2~Time+I(Time^2),random=~Time,subject='ID',ng=1,
data=data_lcmm,link="thresholds")
info <- ItemInfo(m,lprocess=seq(-4,4,length.out=100),draws=TRUE)
plot(info)
par(mfrow=c(1,2))
plot(info, which="LevelInfo", outcome="Yord1")
plot(info, which="LevelInfo", outcome="Yord2")
plot(info, which="LevelProb", outcome="Yord1")
plot(info, which="LevelProb", outcome="Yord2")
}

}
\author{
Cecile Proust-Lima, Viviane Philipps
}
