% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_l_contag.R
\name{lsm_l_contag}
\alias{lsm_l_contag}
\title{CONTAG (landscape level)}
\usage{
lsm_l_contag(landscape, verbose = TRUE)
}
\arguments{
\item{landscape}{A categorical raster object: SpatRaster; Raster* Layer, Stack, Brick; stars or a list of SpatRasters.}

\item{verbose}{Print warning message if not sufficient patches are present}
}
\value{
tibble
}
\description{
Contagion (Aggregation metric)
}
\details{
\deqn{CONTAG = 1 + \frac{\sum \limits_{q = 1}^{n_{a}} p_{q} ln(p_{q})}{2ln(t)}}

where \eqn{p_{q}} the adjacency table for all classes divided by the sum of that table and
\eqn{t} the number of classes in the landscape.

CONTAG is an 'Aggregation metric'. It is based on cell adjacencies and describes
the probability of two random cells belonging to the same class. \eqn{p_{q}} is
the cell adjacency table, where the order is preserved and pairs of adjacent cells
are counted twice. Contagion is affected by both the dispersion and interspersion
of classes. E.g., low class dispersion (= high proportion of like adjacencies) and
low interspersion (= uneven distribution of pairwise adjacencies) lead to a high
contagion value.

The number of classes to calculate CONTAG must be >= than 2.

\subsection{Units}{Percent}
\subsection{Range}{0 < Contag <=100}
\subsection{Behaviour}{Approaches CONTAG = 0 if all cells are unevenly distributed
and 100 indicates that all cells are equally adjacent to all other classes.}
}
\examples{
landscape <- terra::rast(landscapemetrics::landscape)
lsm_l_contag(landscape)

}
\references{
McGarigal K., SA Cushman, and E Ene. 2023. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical Maps. Computer software program produced by the authors;
available at the following web site: https://www.fragstats.org

Riitters, K.H., O'Neill, R.V., Wickham, J.D. & Jones, K.B. (1996). A note on
contagion indices for landscape analysis. Landscape ecology, 11, 197-202.
}
