% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/procrustes.R
\name{ca.procrustes.curve}
\alias{ca.procrustes.curve}
\title{Seriate Using Reference Curve}
\usage{
ca.procrustes.curve(obj, resolution = 10000)
}
\arguments{
\item{obj}{An incidence matrix of size n x k.}

\item{resolution}{Number of samples to use for plotting points along polynomial curve (default is 10000).}
}
\value{
A data frame of the following:.
\itemize{
\item \verb{Procrustes1,Procrustes2} The location of the point on the biplot after fitting.
\item \code{CurveIndex} The orthogonal projection of the point onto the reference curve, given as the index of the point sampled along \eqn{y = \beta_2 x^2 + \beta_0}.
\item \code{Distance} The squared Euclidean distance of the point to the nearest point on the reference curve.
\item \code{Rank} The ranking of the row or column, a range of \verb{1:nrow`` and }1:ncol``.
\item \code{Type} Either \code{row} or \code{col}.
\item \code{sel} Data frame column used in \code{shiny} app to indicate whether point is selected in biplot/curve projection.
}
}
\description{
Obtain a ranking of row and column scores projected onto a reference curve of an ideal seriation (row and column scores are ranked separately). Scores of correspondence analysis have been fit to those produced by reference matrix contain an ideal seriation using a Procrustes method, projecting them. Rotation is determined by minimizing Euclidean distance from each row score to the nearest reference row score. Correspondence analysis is performed using the \code{\link[ca]{ca}} package \insertCite{nenadic_correspondence_2007}{lakhesis}.
}
\examples{
data("quattrofontanili")
ca.procrustes.curve(quattrofontanili)

}
\references{
\insertAllCited{}
}
