% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lama_dictionary.R
\name{lama_get}
\alias{lama_get}
\alias{lama_get.lama_dictionary}
\alias{lama_get_}
\alias{lama_get_.lama_dictionary}
\title{Retrieve a translation from a \link[=new_lama_dictionary]{lama_dictionary} class object}
\usage{
lama_get(.data, translation)

\method{lama_get}{lama_dictionary}(.data, translation)

lama_get_(.data, translation)

\method{lama_get_}{lama_dictionary}(.data, translation)
}
\arguments{
\item{.data}{A \link[=new_lama_dictionary]{lama_dictionary} object}

\item{translation}{Depending on which function was used:
\itemize{
\item \code{lama_get}: An unquoted translation name.
\item \code{lama_get_}: A character string holding the translation name.
}}
}
\value{
The wanted translation (named character vector).
}
\description{
The functions \code{\link[=lama_get]{lama_get()}} and \code{\link[=lama_get_]{lama_get_()}} take a
\link[=new_lama_dictionary]{lama_dictionary} and extract a specific translation.
The function \code{\link[=lama_get]{lama_get()}} uses non-standard evaluation, whereas
\code{\link[=lama_get_]{lama_get_()}} is the standard evaluation alternative.
}
\section{Translations}{

A \emph{translation} is a \emph{named character vector} of non zero length.
This named character vector defines
which labels (of type character) should be assigned to which values
(can be of type character, logical or numeric)
(e.g. the translation \code{c("0" = "urban", "1" = "rural")} assigns the label
\code{"urban"} to the value \code{0} and \code{"rural"} to the value \code{1}, for example the
variable \code{x = c(0, 0, 1)} is translated to \code{x_new = c("urban", "urban", "rural")}).
Therefore, a translation (named character vector) contains the following information:
\itemize{
\item The \emph{names} of the character vector entries correspond to the
\emph{original variable levels}.
Variables of types \code{numeric} or \code{logical} are turned automatically into a
character vector (e.g. \code{0} and \code{1} are treated like \code{"0"} and \code{"1"}).
\item The \emph{entries} (character strings) of the character vector correspond to
the new \emph{labels}, which will be assigned to the original variable levels.
It is also allowed to have missing labels (\code{NA}s).
In this case, the original values are mapped onto missing values.
}

The function \code{\link[=lama_translate]{lama_translate()}} is used in order to apply a translation on a variable.
The resulting vector with the assigned labels can be of the following types:
\itemize{
\item \emph{character}: An unordered vector holding the new character labels.
\item \emph{factor} with character levels: An ordered vector holding the new character labels.
}

The original variable can be of the following types:
\itemize{
\item \emph{character} vector: This is the simplest case. The character values
will replaced by the corresponding labels.
\item \emph{numeric} or \emph{logical} vector: Vectors of type \emph{numeric} or \emph{logical}
will be turned
into \emph{character} vectors automatically before the translation process and
then simply processed like in the \emph{character} case.
Therefore, it is sufficient to define the translation mapping for the
\emph{character} case, since it also covers the \emph{numeric} and \emph{logical} case.
\item \emph{factor} vector with levels of any type: When translating factor variables
one can decide whether or not to keep the original ordering. Like in the
other cases the levels of the factor variable will always be turned into
character strings before the translation process.
}
}

\section{Missing values}{

It is also possible to handle missing values with \code{\link[=lama_translate]{lama_translate()}}.
Therefore, the used translation must contain a information that tells how
to handle a missing value. In order to define such a translation
the missing value (\code{NA}) can be escaped with the character string \code{"NA_"}.
This can be useful in two situations:
\itemize{
\item All missing values should be labeled
(e.g. the translation \code{c("0" = "urban", "1" = "rural", NA_ = "missing")}
assigns the character string \code{"missing"} to all missing values of a variable).
\item Map some original values to \code{NA}
(e.g. the translation \code{c("0" = "urban", "1" = "rural", "2" = "NA_", "3" = "NA_")}
assigns \code{NA} (the missing character) to the original values \code{2} and \code{3}).
Actually, in this case the translation definition does not always have to
use this escape mechanism, but only
when defining the translations inside of a \code{YAML} file,
since the \code{YAML} parser does not recognize missing values.
}
}

\section{lama_dictionary class objects}{

Each \emph{lama_dictionary} class object can contain multiple \emph{translations},
each with a unique name under which the translation can be found.
The function \code{\link[=lama_translate]{lama_translate()}} uses a lama_dictionary class object
to translate a normal \code{vector} or to translate one or more columns in a
\code{data.frame}.
Sometimes it may be necessary to have different translations
for the same variable, in this case it is best to have multiple
translations with different names
(e.g. \code{area_short = c("0" = "urb", "1" = "rur")} and
\code{area = c("0" = "urban", "1" = "rural")}).
}

