% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FindNbrClusters.R
\name{FindNbrClusters}
\alias{FindNbrClusters}
\title{Find the optimal number of clusters}
\usage{
FindNbrClusters(A, structure, k = NULL, k_max = NULL)
}
\arguments{
\item{A}{The adjacency matrix}

\item{structure}{Output of the function \code{FindStructure()}.}

\item{k}{True number of clusters (not necessarily needed). If not provided, k is chosen by spectral eigengap.}

\item{k_max}{Maximal number of clusters to form (not necessarily needed). If not provided, k_max is set to the number of nodes.}
}
\value{
A list with the following elements:
\itemize{
\item{\code{nbr_clusters}}{ Optimal number of clusters by component,}
\item{\code{nbr_clusters_total}}{ Optimal total number of clusters.}
}
}
\description{
This internal function of the l1-spectral algorithm finds the optimal number of clusters to build.
}
\examples{
 #########################################
 # Finding the optimal number of clusters
 #########################################

 # 1st example: non-perturbed graph
 Data <- CreateDataSet(k=3, n=20, p=list(p_inside=0,p_outside=0))

 Structure <- FindStructure(Data$A_hat)

 Clusters <- FindNbrClusters(A = Data$A_hat, structure = Structure, k=3)
 # The number of clusters is provided (3): each of the 3 components will be divided into 1 cluster

 Clusters <- FindNbrClusters(A = Data$A_hat, structure = Structure, k=5)
 # The number of clusters is provided (5) and larger than the number of components (3),
 # the spectral eigengap method is used to find the optimal number of clusters of each component.

 # 2nd example: perturbed graph
 Data <- CreateDataSet(k=3, n=20, p=list(p_inside=0.1,p_outside=0.1))

 Structure <- FindStructure(Data$A_hat) # there are less than 3 components

 Clusters <- FindNbrClusters(A = Data$A_hat, structure = Structure)
 # The number of clusters is optimized using the spectral eigengap method
}
\seealso{
\code{\link{l1_spectralclustering}}, \code{\link{l1spectral}}.
}
\author{
Camille Champion, Magali Champion
}
