% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmbasisneighbourhood.R
\name{kmbasisneighbourhood}
\alias{kmbasisneighbourhood}
\title{Compute the neighbourhod of a state within a knowledge structure using its basis}
\usage{
kmbasisneighbourhood(state, basis, include = FALSE)
}
\arguments{
\item{state}{Binary vector representing a knowledge state}

\item{basis}{\code{kmbasis} object}

\item{include}{Boolean whether the original state should be included
in the result (default FALSE)}
}
\value{
Matrix containing the neighbouring states, one per row
}
\description{
\code{kmbasisneighbourhood} computes the neighbourhood of a state
within a knowledge structure, i.e. the family of all other
states with a symmetric set difference of 1.
}
\examples{
kmbasisneighbourhood(c(1,1,0,0), xpl$basis)

}
\seealso{
Other Fringes & learning paths: 
\code{\link{kmbasisfringe}()},
\code{\link{kmfringe}()},
\code{\link{kmgradations}()},
\code{\link{kmlearningpaths}()},
\code{\link{kmneighbourhood}()},
\code{\link{kmnneighbourhood}()}
}
\concept{Fringes & learning paths}
