% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knnmi.R
\name{cond_mutual_inf}
\alias{cond_mutual_inf}
\title{Conditional mutual information estimation}
\usage{
cond_mutual_inf(X, Y, Z, k = 3L)
}
\arguments{
\item{X}{input vector.}

\item{Y}{input vector or matrix.}

\item{Z}{conditional input vector or matrix.}

\item{k}{number of nearest neighbors.}
}
\value{
Returns the estimated conditional mutual information. The return value is a vector of size 1 if both Y and Z
are vectors. If either Y or Z are matrices the return value is a vector whose size is the number of rows in the
matrix.
}
\description{
Conditional mutual information estimation CMI(X;Y|Z) where X is a continuous vector.
The input Y and conditional input Z can be vectors or matrices. If Y and Z
are discrete then they must be numeric or integer valued.
}
\details{
Argument Y is a vector of the same size as vector X, or a matrix whose column dimension matches
the size of X.  Argument Z is also a vector of the same size as vector X, or a matrix whose column dimension matches
the size of X. If Y and Z are both matrices they must additionally have the same number of rows.  If Y and/or Z are
discrete values they must have a numeric or integer type.
}
\examples{
data(mutual_info_df)
set.seed(654321)
cond_mutual_inf(mutual_info_df$Zc_XcYc,
                       mutual_info_df$Xc, t(mutual_info_df$Yc))

M <- cbind(mutual_info_df$Xc, mutual_info_df$Yc)
ZM <- cbind(mutual_info_df$Yc, mutual_info_df$Wc)
cond_mutual_inf(mutual_info_df$Zc_XcYcWc, t(M), t(ZM))


}
\references{
Alkiviadis Tsimpiris, Ioannis Vlachos, Dimitris Kugiumtzis,
Nearest neighbor estimate of conditional mutual information in feature selection,
Expert Systems with Applications,
Volume 39, Issue 16, 2012, Pages 12697-12708
\doi{10.1016/j.eswa.2012.05.014}
}
