% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcplot.R
\name{pcplot}
\alias{pcplot}
\title{Principal Component Plot for K-Means Clustering}
\usage{
pcplot(data, clusters, barColor = "steelblue",
  colorScheme = "schemeCategory10", width = NULL, height = NULL,
  labelSizes = NULL, dotSize = NULL, pcGridlines = FALSE,
  barGridlines = FALSE)
}
\arguments{
\item{data}{A dataframe of numeric columns.
Scaled data is preferred as PCA does not work the same with non-scaled data.}

\item{clusters}{A named integer matrix of clusters where names are the row names
of the above dataframe and integers are the integer value of the row's associated cluster.
This can be obtained from a function such as \code{ stats::kmeans()$cluster }.}

\item{barColor}{The color to use for the bar-chart fill. May be any html color (hex or named).}

\item{colorScheme}{The color scheme of the PCA plot. May be a pre-configured D3 ordinal color scheme
or a vector of html colors (hex or named) of the same length as the number of clusters.}

\item{width}{The width of the plot window.}

\item{height}{The height of the plot window.}

\item{labelSizes}{A number or list of any combination of parameters shown that define the label sizes. \cr
\code{ list(yaxis = 12, yticks = 10, tooltip = 15) }}

\item{dotSize}{A number to adjust the size of the dots.}

\item{pcGridlines}{\code{ TRUE } \code{ FALSE } Show grid-lines on the PC plots?}

\item{barGridlines}{\code{ TRUE } \code{ FALSE } Show grid-lines on the bar-charts?}
}
\description{
Reduces dimensionality to 2D using principal component analysis (PCA)
and displays a dynamic visualization of two principal components (PC).
}
\details{
\itemize{
  \item Clicking on axis labels will display a bar-chart of PC contribution
  \item Clicking on legend colors will fade out all points but the points in the cluster selected
  \item Hover over points to see the label and point coordinates
}
}
\examples{

# Barebones
scaled_df <- scale(state.x77)
clus <- kmeans(scaled_df, 5)$cluster
pcplot(data = scaled_df, clusters = clus)

# With Options
scaled_df <- scale(state.x77)
clus <- kmeans(scaled_df, 5)$cluster
pcplot(data = scaled_df, clusters = clus,
       barColor = "red",
       colorScheme = c("red", "green", "orange", "blue", "yellow"),
       labelSizes = list(yaxis = 20, yticks = 15, tooltip = 25),
       pcGridlines = TRUE, barGridlines = TRUE)


}
