% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{trapz}
\alias{trapz}
\title{Trapezoidal integration in 1 or 2 dimensions}
\usage{
trapz(h, fx)
}
\arguments{
\item{h}{A length \code{d} numeric vector of grid widths.}

\item{fx}{A \code{d}-dimensional array (or a vector, if \code{d=1}).}
}
\value{
The trapezoidal approximation of the integral.
}
\description{
Trapezoidal integration in 1 or 2 dimensions
}
\examples{
# 1D example
trapz(h = 1, fx = 1:10)
# 2D example
trapz(h = c(1,1), fx = matrix(1:10, nrow = 2))
}
