% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kld-estimation-kernel-density.R
\name{kld_est_kde1}
\alias{kld_est_kde1}
\title{1-D kernel density-based estimation of Kullback-Leibler divergence}
\usage{
kld_est_kde1(X, Y, MC = FALSE, ...)
}
\arguments{
\item{X, Y}{Numeric vectors or single-column matrices, representing samples
from the true distribution \eqn{P} and the approximate distribution
\eqn{Q}, respectively.}

\item{MC}{A boolean: use a Monte Carlo approximation instead of numerical
integration via the trapezoidal rule (default: \code{FALSE})?}

\item{...}{Further parameters to passed on to \code{stats::density} (e.g.,
argument \code{bw})}
}
\value{
A scalar, the estimated Kullback-Leibler divergence \eqn{\hat D_{KL}(P||Q)}.
}
\description{
This estimation method approximates the densities of the unknown distributions
\eqn{P} and \eqn{Q} by a kernel density estimate using function 'density' from
package 'stats'. Only the two-sample, not the one-sample problem is implemented.
}
\examples{
# KL-D between two samples from 1D Gaussians:
set.seed(0)
X <- rnorm(100)
Y <- rnorm(100, mean = 1, sd = 2)
kld_gaussian(mu1 = 0, sigma1 = 1, mu2 = 1, sigma2 = 2^2)
kld_est_kde1(X,Y)
kld_est_kde1(X,Y, MC = TRUE)
}
