% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversions.R
\name{perform_conversions}
\alias{perform_conversions}
\title{Perform unit and code conversions used by KFRE helpers.}
\usage{
perform_conversions(
  df,
  reverse = FALSE,
  convert_all = FALSE,
  upcr_col = NULL,
  calcium_col = NULL,
  phosphate_col = NULL,
  albumin_col = NULL
)
}
\arguments{
\item{df}{Data frame with source columns to convert.}

\item{reverse}{Logical, reverse the conversion if \code{TRUE}.}

\item{convert_all}{Logical, convert all known columns if \code{TRUE}.}

\item{upcr_col}{Column name for urine protein creatinine ratio.}

\item{calcium_col}{Optional column for serum calcium, mg/dL.}

\item{phosphate_col}{Optional column for serum phosphorus, mg/dL.}

\item{albumin_col}{Optional column for serum albumin, g/dL.}
}
\value{
A data frame with converted columns.
}
\description{
Perform unit and code conversions used by KFRE helpers.
}
\examples{
df <- data.frame(
  upcr = c(100, 400),         # mg/g (or g/g scaled accordingly)
  albumin = c(40, 38),        # g/L
  phosphorous = c(1.1, 1.3),  # mmol/L
  calcium = c(9.2, 8.8)       # mg/dL
)
perform_conversions(df)
}
