% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parseBarcodedReads.R
\name{callSampleLables}
\alias{callSampleLables}
\title{Call sample labels based on feature counts}
\usage{
callSampleLables(
  TapestriExperiment,
  input.features,
  output.feature = "sample.call",
  return.table = FALSE,
  neg.label = NA,
  method = "max",
  ties.method = "first",
  min.count.threshold = 1
)
}
\arguments{
\item{TapestriExperiment}{A \code{TapestriExperiment} object.}

\item{input.features}{Character vector, column names in \code{colData} to evaluate.}

\item{output.feature}{Character, column name to use for the call output. Default "sample.call".}

\item{return.table}{Logical, if \code{TRUE}, returns a data.frame of the sample.calls. If \code{FALSE} (default), returns updated \code{TapestriExperiment} object.}

\item{neg.label}{Character, label for samples with no counts. Default \code{NA}.}

\item{method}{Character, call method. Only "max" currently supported, calls based on whichever \code{input.features} column has the most counts.}

\item{ties.method}{Character, passed to \code{max.col()} indicating how to break ties. Default "first".}

\item{min.count.threshold}{Numeric, minimum number of counts per cell to use for call. Default 1.}
}
\value{
A \code{TapestriExperiment} object with sample calls added to \code{colData} column \code{sample.name}. If \code{return.table == TRUE}, a \code{data.frame} of sample calls.
}
\description{
\code{callSampleLables()} assigns labels (stored as \code{colData} column) to cells using feature count data in \code{colData}.
This is most useful for assigning barcode labels based on barcoded reads (see \link{countBarcodedReads}).
For \code{method = max}, labels are dictated by whichever \code{input.features} column has the highest number of counts.
By default, ties are broken by choosing whichever label has the lowest index position (\code{ties.method = "first"}).
Samples with 0 counts for all \code{input.features} columns are labeled according to \code{neg.label}.
If only one feature column is used, labels are assigned to cells with counts > \code{min.count.threshold}, and \code{neg.label} otherwise.
}
\examples{
tap.object <- newTapestriExperimentExample() # example TapestriExperiment object
colData(tap.object)$gRNA1 <- 2 # example barcode counts
colData(tap.object)$gRNA2 <- 10 # example barcode counts
tap.object <- callSampleLables(tap.object,
  input.features = c("gRNA1", "gRNA2"),
  output.feature = "sample.grna"
)
}
\concept{barcoded reads}
