% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kappa.R
\name{kappa2}
\alias{kappa2}
\title{Cohen's kappa for nominal data}
\usage{
kappa2(ratings, robust = FALSE, ratingScale = NULL)
}
\arguments{
\item{ratings}{matrix (dimension nx2), containing the ratings as subjects by
raters}

\item{robust}{flag. Use robust estimate for random chance of agreement by
Brennan-Prediger?}

\item{ratingScale}{Possible levels for the rating. Or \code{NULL}.}
}
\value{
list containing Cohen's kappa agreement measure (value) or \code{NULL} if
no valid subjects
}
\description{
Cohen's kappa is the classical agreement measure when two raters provide
ratings for subjects on a nominal scale.
}
\details{
The data of ratings must be stored in a two column object, each rater is a
column and the subjects are in the rows. Every rating category is used and
the levels are sorted. Weighting of categories is currently not implemented.
}
\examples{
# 2 raters have assessed 4 subjects into categories "A", "B" or "C"
# organize ratings as two column matrix, one row per subject rated
m <- rbind(sj1 = c("A", "A"),
           sj2 = c("C", "B"),
           sj3 = c("B", "C"),
           sj4 = c("C", "C"))
           
# Cohen's kappa -----
kappa2(ratings = m)

# robust variant ---------
kappa2(ratings = m, robust = TRUE)

}
\seealso{
\code{\link[irr:kappa2]{irr::kappa2()}}
}
