% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_Dir.R
\name{Dir}
\alias{Dir}
\alias{ddir}
\alias{rdir}
\alias{d,Dir,numeric-method}
\alias{d,Dir,matrix-method}
\alias{r,Dir,numeric-method}
\alias{mean,Dir-method}
\alias{mode,Dir-method}
\alias{var,Dir-method}
\alias{entro,Dir-method}
\alias{finf,Dir-method}
\alias{lldir}
\alias{ll,Dir,matrix-method}
\alias{edir}
\alias{mle,Dir,matrix-method}
\alias{me,Dir,matrix-method}
\alias{same,Dir,matrix-method}
\alias{vdir}
\alias{avar_mle,Dir-method}
\alias{avar_me,Dir-method}
\alias{avar_same,Dir-method}
\title{Dirichlet Distribution}
\usage{
Dir(alpha = c(1, 1))

ddir(x, alpha, log = FALSE)

rdir(n, alpha)

\S4method{d}{Dir,numeric}(distr, x, log = FALSE)

\S4method{d}{Dir,matrix}(distr, x)

\S4method{r}{Dir,numeric}(distr, n)

\S4method{mean}{Dir}(x)

\S4method{mode}{Dir}(x)

\S4method{var}{Dir}(x)

\S4method{entro}{Dir}(x)

\S4method{finf}{Dir}(x)

lldir(x, alpha)

\S4method{ll}{Dir,matrix}(distr, x)

edir(x, type = "mle", ...)

\S4method{mle}{Dir,matrix}(
  distr,
  x,
  par0 = "same",
  method = "L-BFGS-B",
  lower = 1e-05,
  upper = Inf,
  na.rm = FALSE
)

\S4method{me}{Dir,matrix}(distr, x, na.rm = FALSE)

\S4method{same}{Dir,matrix}(distr, x, na.rm = FALSE)

vdir(alpha, type = "mle")

\S4method{avar_mle}{Dir}(distr)

\S4method{avar_me}{Dir}(distr)

\S4method{avar_same}{Dir}(distr)
}
\arguments{
\item{alpha}{numeric. The non-negative distribution parameter vector.}

\item{x}{For the density function, \code{x} is a numeric vector of quantiles. For
the moments functions, \code{x} is an object of class \code{Dir}. For the
log-likelihood and the estimation functions, \code{x} is the sample of
observations.}

\item{log}{logical. Should the logarithm of the probability be
returned?}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken to
be the number required.}

\item{distr}{an object of class \code{Dir}.}

\item{type}{character, case ignored. The estimator type (mle, me, or same).}

\item{...}{extra arguments.}

\item{par0, method, lower, upper}{arguments passed to optim for the mle
optimization.}

\item{na.rm}{logical. Should the \code{NA} values be removed?}
}
\value{
Each type of function returns a different type of object:
\itemize{
\item Distribution Functions: When supplied with one argument (\code{distr}), the
\code{d()}, \code{p()}, \code{q()}, \code{r()}, \code{ll()} functions return the density, cumulative
probability, quantile, random sample generator, and log-likelihood functions,
respectively. When supplied with both arguments (\code{distr} and \code{x}), they
evaluate the aforementioned functions directly.
\item Moments: Returns a numeric, either vector or matrix depending on the moment
and the distribution. The \code{moments()} function returns a list with all the
available methods.
\item Estimation: Returns a list, the estimators of the unknown parameters. Note
that in distribution families like the binomial, multinomial, and negative
binomial, the size is not returned, since it is considered known.
\item Variance: Returns a named matrix. The asymptotic covariance matrix of the
estimator.
}
}
\description{
The Dirichlet distribution is an absolute continuous probability,
specifically a multivariate generalization of the beta distribution,
parameterized by a vector \eqn{\boldsymbol{\alpha} =
(\alpha_1, \alpha_2, ..., \alpha_k)} with \eqn{\alpha_i > 0}.
}
\details{
The probability density function (PDF) of the Dirichlet distribution is given
by:
\deqn{ f(x_1, ..., x_k; \alpha_1, ..., \alpha_k) =
\frac{1}{B(\boldsymbol{\alpha})} \prod_{i=1}^k x_i^{\alpha_i - 1}, }
where \eqn{B(\boldsymbol{\alpha})} is the multivariate Beta function:
\deqn{ B(\boldsymbol{\alpha}) = \frac{\prod_{i=1}^k
\Gamma(\alpha_i)}{\Gamma\left(\sum_{i=1}^k \alpha_i\right)} }
and \eqn{\sum_{i=1}^k x_i = 1}, \eqn{x_i > 0}.
}
\examples{
# -----------------------------------------------------
# Dir Distribution Example
# -----------------------------------------------------

# Create the distribution
a <- c(0.5, 2, 5)
D <- Dir(a)

# ------------------
# dpqr Functions
# ------------------

d(D, c(0.3, 0.2, 0.5)) # density function
x <- r(D, 100) # random generator function

# alternative way to use the function
df <- d(D) ; df(x) # df is a function itself

# ------------------
# Moments
# ------------------

mean(D) # Expectation
mode(D) # Mode
var(D) # Variance
entro(D) # Entropy
finf(D) # Fisher Information Matrix

# List of all available moments
mom <- moments(D)
mom$mean # expectation

# ------------------
# Point Estimation
# ------------------

ll(D, x)
lldir(x, a)

edir(x, type = "mle")
edir(x, type = "me")

mle(D, x)
me(D, x)
e(D, x, type = "mle")

mle("dir", x) # the distr argument can be a character

# ------------------
# Estimator Variance
# ------------------

vdir(a, type = "mle")
vdir(a, type = "me")

avar_mle(D)
avar_me(D)

v(D, type = "mle")
}
\references{
\itemize{
\item Oikonomidis, I. & Trevezas, S. (2025), Moment-Type Estimators for the
Dirichlet and the Multivariate Gamma Distributions, arXiv,
https://arxiv.org/abs/2311.15025
}
}
